from maps.wikimap.stat.libs.nile_utils import (
    get_tables_with_names,
    put_tables_by_prefixes,
)
from maps.wikimap.stat.assessment.libs.date_utils import (
    MAX_GRADE_DELAY_DAYS,
    extend_with_prior_days,
)
from maps.wikimap.stat.assessment.tasks_dataset.lib.tasks_dataset import (
    DATASET_SCHEMA,
    make_dataset,
)
from nile.api.v1 import cli
from qb2.api.v1 import typing


@cli.statinfra_job(options=[
    cli.Option(
        'recalc-prior-days',
        default=MAX_GRADE_DELAY_DAYS,
        help=f'Also recalculate for dates prior to specified. Defaults to {MAX_GRADE_DELAY_DAYS}.',
   ),
])
def make_job(job, options):
    dates = extend_with_prior_days(options.dates, int(options.recalc_prior_days))

    make_dataset(
        job=job,
        tasks_log=job.table('//home/maps/core/nmaps/analytics/assessment/tasks_log/{' + ','.join(dates) + '}'),
        graded_units_log=job.table('//home/maps/core/nmaps/analytics/assessment/graded_units_log/{' + ','.join(dates) + '}'),
        puid_map=job.table('//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/puid_map/' + max(dates)),
        tariffs_with_dates=get_tables_with_names(
            job,
            '//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/task_tariff_map/',
            'tariff_date', dates,
        ).cast(
            task_id=typing.Unicode,
            task_name_tree=typing.Unicode,
        ),
        major_regions_map=job.table('//home/maps/core/nmaps/analytics/geo-data/major_regions_map'),
    ).call(
        put_tables_by_prefixes,
        '//home/maps/core/nmaps/analytics/assessment/datasets/tasks/',
        'action_date', dates,
        DATASET_SCHEMA,
    )

    return job


def main():
    cli.run()
