from .commits import get_unmoderated_edits_tasks, get_moderation_tasks
from .feedback import get_feedback_tasks
from .schema import TASKS_LOG_SCHEMA
from .tracker import get_tracker_tasks


def make_tasks_log(
    job,
    dates,
    commit_event_table,
    social_task_table,
    feedback_task_table,
    components_table,
    issue_events_table,
    issues_table,
    resolutions_table,
    statuses_table,
    linked_accounts,
):
    '''
    commit_event_table:
    | event_id | created_at | bounds_geom | primary_object_category_id | ... |
    |----------+------------+-------------+----------------------------+-----|
    | ...      | ...        | ...         | ...                        | ... |

    social_task_table:
    | event_id | created_at | resolved_at | resolved_by | closed_at | closed_by | ... |
    |----------+------------+-------------+-------------+-----------+-----------+-----|
    | ...      | ...        | ...         | ...         | ...       | ...       | ... |

    feedback_task_table:
    | id  | created_at | position | source | type | ... |
    |-----+------------+----------+--------+------+-----|
    | ... | ...        | ...      | ...    | ...  | ... |

    components_table:
    | id  | name | ... |
    |-----+------+-----|
    | ... | ...  | ... |

    issue_events_table:
    | issue | date (ms) | changes (yson)             | ... |
    |-------+-----------+----------------------------+-----|
    | ...   | ...       | [                          | ... |
    |       |           |   {                        |     |
    |       |           |      'field': 'fieldName', |     |
    |       |           |      'newValue': {         |     |
    |       |           |        'value': yson_value |     |
    |       |           |      },                    |     |
    |       |           |      ...                   |     |
    |       |           |   },                       |     |
    |       |           |   ...                      |     |
    |       |           | ]                          |     |

    issues_table:
    | id  | key                   | resolution | assignee | components | storyPoints | ... |
    |-----+-----------------------+------------+----------+------------+-------------+-----|
    | ... | <queue name>-<number> | ...        | ...      | ...        | ...         | ... |

    resolutions_table:
    | id  | key                           | ... |
    |-----+-------------------------------+-----|
    | ... | internal name of a resolution | ... |

    statuses_table:
    | id  | key                       | ... |
    |-----+---------------------------+-----|
    | ... | internal name of a status | ... |

    linked_accounts:
    | staff_uid | puid | ... |
    |-----------+------+-----|
    | ...       | ...  | ... |

    result:
    | entity_id | entity_domain | action_by | action_at | action | task_id | region_id |
    |-----------+---------------+-----------+-----------+--------+---------+-----------|
    | ...       | ...           | ...       | ...       | ...    | ...     | ...       |
    '''
    return job.concat(
        get_unmoderated_edits_tasks(commit_event_table, social_task_table, min(dates)),
        get_moderation_tasks(commit_event_table, social_task_table, min(dates)),
        get_feedback_tasks(feedback_task_table, min(dates)),
        get_tracker_tasks(
            dates,
            components_table=components_table,
            issue_events_table=issue_events_table,
            issues_table=issues_table,
            resolutions_table=resolutions_table,
            statuses_table=statuses_table,
            linked_accounts=linked_accounts,
        )
    ).cast(**TASKS_LOG_SCHEMA)
