from maps.wikimap.stat.assessment.tasks_log.lib.commits import (
    _get_edits_task_id,
    get_unmoderated_edits_tasks,
    get_moderation_tasks,
)
from maps.wikimap.stat.libs import nile_ut
from nile.api.v1 import Record
from yt.yson import to_yson_type
import pytest


def test_should_get_edits_task_id():
    assert 'edits/action1/category_id1' == _get_edits_task_id('action1', 'category_id1')
    assert 'edits/action2/common' == _get_edits_task_id('action2', None)


@pytest.fixture
def mock_geobase(monkeypatch):
    PATCHED_MODULE = 'maps.wikimap.stat.assessment.tasks_log.lib.commits.'
    monkeypatch.setattr(PATCHED_MODULE + 'mercator_geom_to_region_id', int)
    monkeypatch.setattr(PATCHED_MODULE + 'GEOBASE_FILES', [])


def test_should_get_unmoderated_edits_tasks(mock_geobase):
    result = nile_ut.yql_run(
        get_unmoderated_edits_tasks,
        commit_event_table=nile_ut.Table([
            # should exclude commits created_at < min_action_date
            Record(
                commit_id=1,
                type=to_yson_type('edit'),
                created_at='2021-07-07suffix1',
                created_by=11,
                action='action1',
                bounds_geom='101',
                primary_object_category_id='category_id1',
                test_column1=91,
            ),

            # should exclude moderated commits
            Record(
                commit_id=2,
                type=to_yson_type('edit'),
                created_at='2021-07-08suffix2',
                created_by=12,
                action='action2',
                bounds_geom='102',
                primary_object_category_id='category_id2',
                test_column1=92,
            ),

            # should add task_id and region_id
            Record(
                commit_id=3,
                type=to_yson_type('edit'),
                created_at='2021-07-08suffix3',
                created_by=13,
                action='action3',
                bounds_geom='103',
                primary_object_category_id='category_id3',
                test_column1=93,
            ),
            Record(
                commit_id=4,
                type=to_yson_type('edit'),
                created_at='2021-07-09suffix4',
                created_by=14,
                action='action4',
                bounds_geom='104',
                primary_object_category_id=None,
                test_column1=94,
            ),

            # should ignore non-edit events
            Record(
                commit_id=5,
                type=to_yson_type('non-edit'),
                created_at='2021-07-09suffix5',
                created_by=15,
                action='action5',
                bounds_geom='105',
                primary_object_category_id='category_id5',
                test_column1=95,
            ),
        ]),
        social_task_table=nile_ut.Table([
            Record(commit_id=2, created_at='2021-07-08suffix2', test_column2=992),
            Record(commit_id=6, created_at='2021-07-08suffix6', test_column2=996),
        ]),
        min_action_date='2021-07-08',
    )
    assert sorted([
        Record(
            entity_domain='edits',
            entity_id='3',
            action_by=13,
            action_at='2021-07-08suffix3',
            action='action3',
            task_id='edits/action3/category_id3',
            region_id=103,
        ),
        Record(
            entity_domain='edits',
            entity_id='4',
            action_by=14,
            action_at='2021-07-09suffix4',
            action='action4',
            task_id='edits/action4/common',
            region_id=104,
        ),
    ]) == sorted(result)


def test_should_get_moderation_tasks(mock_geobase):
    result = nile_ut.yql_run(
        get_moderation_tasks,
        commit_event_table=nile_ut.Table([
            Record(
                event_id=1,
                created_at='2021-07-07suffix1',
                bounds_geom='11',
                primary_object_category_id='category_id1',
                test_column1=91,
            ),
            Record(
                event_id=2,
                created_at='2021-07-07suffix2',
                bounds_geom='12',
                primary_object_category_id='category_id2',
                test_column1=92,
            ),
            Record(
                event_id=3,
                created_at='2021-07-07suffix3',
                bounds_geom='13',
                primary_object_category_id='category_id3',
                test_column1=93,
            ),
            Record(
                event_id=4,
                created_at='2021-07-07suffix4',
                bounds_geom='14',
                primary_object_category_id=None,
                test_column1=94,
            ),
            Record(
                event_id=5,
                created_at='2021-07-07suffix5',
                bounds_geom='15',
                primary_object_category_id='category_id5',
                test_column1=95,
            ),
        ]),
        social_task_table=nile_ut.Table([
            Record(
                event_id=2,
                resolved_by=None,
                resolved_at=None,
                closed_by=None,
                closed_at=None,
                test_column2=992,
            ),
            Record(
                event_id=3,
                resolved_by=113,
                resolved_at='2021-07-07suffix3',
                closed_by=None,
                closed_at=None,
                test_column2=993,
            ),
            Record(
                event_id=4,
                resolved_by=114,
                resolved_at='2021-07-07suffix41',
                closed_by=124,
                closed_at='2021-07-08suffix42',
                test_column2=994,
            ),
            Record(
                event_id=5,
                resolved_by=115,
                resolved_at='2021-07-08suffix51',
                closed_by=125,
                closed_at='2021-07-09suffix52',
                test_column2=995,
            ),
        ]),
        min_action_date='2021-07-08',
    )
    assert sorted([
        Record(
            entity_domain='moderation',
            entity_id='4',
            action_by=124,
            action_at='2021-07-08suffix42',
            action='close',
            task_id='moderation/closed/common',
            region_id=14,
        ),
        Record(
            entity_domain='moderation',
            entity_id='5',
            action_by=115,
            action_at='2021-07-08suffix51',
            action='resolve',
            task_id='moderation/resolved/category_id5',
            region_id=15,
        ),
        Record(
            entity_domain='moderation',
            entity_id='5',
            action_by=125,
            action_at='2021-07-09suffix52',
            action='close',
            task_id='moderation/closed/category_id5',
            region_id=15,
        ),
    ]) == sorted(result)
