from maps.wikimap.stat.assessment.tasks_log.lib.feedback import get_feedback_tasks
from maps.wikimap.stat.libs import nile_ut
from nile.api.v1 import Record
from qb2.api.v1 import typing
from yt.yson import to_yson_type
import pytest


@pytest.fixture
def geobase_mock(monkeypatch):
    PATCHED_MODULE = 'maps.wikimap.stat.assessment.tasks_log.lib.feedback.'
    monkeypatch.setattr(PATCHED_MODULE + 'lon_lat_position_to_region_id', int)
    monkeypatch.setattr(PATCHED_MODULE + 'GEOBASE_FILES', [])


def test_should_get_feedback_tasks(geobase_mock):
    result = nile_ut.yql_run(
        get_feedback_tasks,
        feedback_task_table=nile_ut.Table(
            [
                Record(
                    id=1,
                    position='101',
                    source=b'source1',
                    type=b'type1',
                    resolved_at=None,
                    history=to_yson_type([
                        {b'operation': b'need-info', b'modifiedBy': 11, b'modifiedAt': b'2020-07-08 01:01:01+01:01'},
                    ]),
                    test_column='test1',
                ),
                Record(
                    id=2,
                    position='102',
                    source=b'source2',
                    type=b'type2',
                    resolved_at='2021-07-07 01:01:01+01:01',
                    history=to_yson_type([
                        {b'operation': b'accept',    b'modifiedBy': 11, b'modifiedAt': b'2021-07-07 01:01:01+01:01'},
                    ]),
                    test_column='test2',
                ),
                Record(
                    id=3,
                    position='103',
                    source=b'source3',
                    type=b'type3',
                    resolved_at='2021-07-09 01:01:01+01:01',
                    history=to_yson_type([
                        {b'operation': b'need-info', b'modifiedBy': 12, b'modifiedAt': b'2021-07-07 01:01:01+01:01'},
                        {b'operation': b'accept',    b'modifiedBy': 13, b'modifiedAt': b'2021-07-08 01:01:01+01:01'},
                        {b'operation': b'accept',    b'modifiedBy': 14, b'modifiedAt': b'2021-07-09 01:01:01+01:01'},
                    ]),
                    test_column='test3',
                ),
            ],
            schema={
                'id':          typing.Int64,
                'position':    typing.Optional[typing.Yson],
                'source':      typing.Yson,
                'type':        typing.Yson,
                'resolved_at': typing.Optional[typing.Unicode],
                'history':     typing.Yson,
            },
        ),
        min_action_date='2021-07-08',
    )
    assert sorted([
        Record(
            entity_id='3',
            entity_domain='feedback',
            action_by=13,
            action_at='2021-07-08 01:01:01+01:01',
            action='accept',
            task_id='feedback/accept/source3/type3',
            region_id=103,
        ),
        Record(
            entity_id='3',
            entity_domain='feedback',
            action_by=14,
            action_at='2021-07-09 01:01:01+01:01',
            action='accept',
            task_id='feedback/accept/source3/type3',
            region_id=103,
        ),
    ]) == sorted(result)
