from maps.wikimap.stat.assessment.tasks_log.lib.tasks_log import make_tasks_log
from maps.wikimap.stat.assessment.tasks_log.lib.schema import TASKS_LOG_SCHEMA
from maps.wikimap.stat.libs.nile_utils import (
    get_tables_with_names,
    put_tables_by_prefixes,
)
from nile.api.v1 import cli


@cli.statinfra_job
def make_job(job, options):
    make_tasks_log(
        job,
        options.dates,
        commit_event_table=job.table('//home/maps/core/nmaps/dynamic/replica/social/social_commit_event'),
        social_task_table=job.concat(
            job.table('//home/maps/core/nmaps/dynamic/replica/social/social_task_active'),
            job.table('//home/maps/core/nmaps/dynamic/replica/social/social_task_closed'),
        ),
        feedback_task_table=job.table('//home/maps/core/nmaps/analytics/feedback/db/feedback_latest'),
        components_table=job.table('//home/startrek/tables/prod/yandex-team/queue/maps-pw/components'),
        issue_events_table=job.table('//home/startrek/tables/prod/yandex-team/queue/maps-pw/issue_events'),
        issues_table=job.table('//home/startrek/tables/prod/yandex-team/queue/maps-pw/issues'),
        resolutions_table=job.table('//home/startrek/tables/prod/yandex-team/common/resolutions'),
        statuses_table=job.table('//home/startrek/tables/prod/yandex-team/common/statuses'),
        linked_accounts=get_tables_with_names(
            job,
            '//home/maps/core/nmaps/analytics/tasks_payment/dictionaries/linked_accounts/',
            'date', options.dates,
        ),
    ).call(
        put_tables_by_prefixes,
        '//home/maps/core/nmaps/analytics/assessment/tasks_log/',
        'action_at', options.dates,
        TASKS_LOG_SCHEMA,
    )

    return job


def main():
    cli.run()
