import datetime
import argparse
import collections

from nile.api.v1 import (
    clusters,
    datetime as nd,
    statface as ns
)

import eval_report


def main():

    parser = argparse.ArgumentParser()

    parser.add_argument("--start-date", type=str, help="Start date", default='')
    parser.add_argument("--end-date", type=str, help="End date", default='')
    parser.add_argument("--statface-token", type=str, help="Statface token", required=True)
    parser.add_argument("--yt-token", type=str, help="Yt token")
    parser.add_argument("--production", type=bool, default=False)

    args = parser.parse_args()

    start_date = nd.Datetime.from_iso(args.start_date) if args.start_date else datetime.date.today() - datetime.timedelta(days=1)
    end_date = nd.Datetime.from_iso(args.end_date) if args.end_date else start_date
    assert (start_date <= end_date)

    if args.yt_token:
        cluster = clusters.yt.Hahn(args.yt_token)
    else:
        cluster = clusters.yt.Hahn()

    statface_client_cls = ns.StatfaceProductionClient if args.production else ns.StatfaceBetaClient
    statface_client = statface_client_cls(
        token=args.statface_token
    )

    job = cluster.job()

    options = collections.namedtuple("Options", "dates yesterday")(
        '{' + str(start_date.date()) + '..' + str(end_date.date()) + '}',
        False
    )

    job = eval_report.make_job(job, None, options, statface_client)

    job.run()


if __name__ == "__main__":
    main()
