import argparse
import os

YT_PROXY = 'hahn'
GEODATA_DIR = '//home/maps/core/nmaps/analytics/geo-data'


def make_parser():
    parser = argparse.ArgumentParser()
    parser.add_argument('--token', help='Overrides YT_TOKEN and yt config')
    parser.add_argument(
        '--proxy',
        help='Overrides YT_PROXY. If neither --proxy nor YT_PROXY is set, defaults to {}'.format(YT_PROXY),
        default=os.environ['YT_PROXY'] if 'YT_PROXY' in os.environ else YT_PROXY
    )
    parser.add_argument(
        '--results',
        help='Destination path on yt cluster. Defaults to {}'.format(GEODATA_DIR),
        default=GEODATA_DIR
    )

    return parser
