from maps.wikimap.stat.common.create_geo_data.lib.regions import get_region_info, EARTH_REGION_ID


def check_region_info(regions, region_id, region_name, facet=None):
    assert {
        'region_id': region_id,
        'region_name': region_name,
        'facet': facet,
    } == get_region_info(regions, str(region_id))


def test_get_region_info_should_map_region_id_to_least_major_region_name():
    regions = {
        '1': {'region_id': '1', 'full_name': 'major_parent',  'least_major_id': '1', 'parent_id': str(EARTH_REGION_ID), 'facet_id': None},
        '2': {'region_id': '2', 'full_name': 'major_child',   'least_major_id': '2', 'parent_id': '1',                  'facet_id': None},
        '3': {'region_id': '3', 'full_name': 'minor_parent',  'least_major_id': '2', 'parent_id': '2',                  'facet_id': None},
        '4': {'region_id': '4', 'full_name': 'minor_child',   'least_major_id': '2', 'parent_id': '3',                  'facet_id': None},
    }

    check_region_info(regions, 1, 'major_parent')
    check_region_info(regions, 2, 'major_child')
    check_region_info(regions, 3, 'major_child')
    check_region_info(regions, 4, 'major_child')


def test_get_region_info_should_get_facet_only_from_region_or_its_ancestors():
    regions = {
        '1': {'region_id': '1', 'full_name': 'region_with_no_facet',        'least_major_id': '1', 'parent_id': str(EARTH_REGION_ID), 'facet_id': None},
        '2': {'region_id': '2', 'full_name': 'region_with_facet',           'least_major_id': '2', 'parent_id': '1',                  'facet_id': '4'},
        '3': {'region_id': '3', 'full_name': 'child_of_region_with_facet',  'least_major_id': '3', 'parent_id': '2',                  'facet_id': None},

        '4': {'region_id': '4', 'name': 'facet'},
    }

    check_region_info(regions, 1, 'region_with_no_facet')
    check_region_info(regions, 2, 'region_with_facet',          'facet')
    check_region_info(regions, 3, 'child_of_region_with_facet', 'facet')
