import argparse

from nile.api.v1 import clusters

from maps.wikimap.stat.community.shown_addresses.lib.make_job import make_job


def main():
    parser = argparse.ArgumentParser(
        description="Use environment variables 'YT_TOKEN' for OAuth authorisation."
    )
    parser.add_argument('--creation-start', help='Addresses creation period first date, iso format: 2018-12-31', required=True)
    parser.add_argument('--creation-finish', help='Addresses creation period last date, iso format: 2018-12-31', required=True)
    parser.add_argument('--show-start', help='Addresses show period fist date, iso format: 2018-12-31', required=True)
    parser.add_argument('--show-finish', help='Addresses show period last date, iso format: 2018-12-31', required=True)
    parser.add_argument('--result-table', help='Path to the resulting table', required=True)
    args = parser.parse_args()

    cluster = clusters.yt.Hahn()

    job = cluster.job('community-mail-addresses')

    job = make_job(
        job, args.result_table,
        args.creation_start, args.creation_finish,
        args.show_start, args.show_finish
    )

    job.run()


if __name__ == '__main__':
    main()
