import datetime

from nile.api.v1 import (
    cli
)

from maps.wikimap.stat.community.shown_addresses.lib.make_job import make_job

RESULT_TABLE_FORMAT = '//home/maps/core/nmaps/production/mailing/community/addresses/shows_{suffix}'

SHOW_PERIOD_DAYS = 30
CREATION_PERIOD_DAYS = 365


@cli.statinfra_job
def make_nirvana_job(job):
    show_finish_date = datetime.date.today() - datetime.timedelta(days=2)
    show_finish = show_finish_date.isoformat()
    show_start = (show_finish_date - datetime.timedelta(days=SHOW_PERIOD_DAYS)).isoformat()
    creation_start = (show_finish_date - datetime.timedelta(days=CREATION_PERIOD_DAYS)).isoformat()
    creation_finish = show_finish

    table_suffix = '{}_{}_{}'.format(CREATION_PERIOD_DAYS, SHOW_PERIOD_DAYS, datetime.date.today().isoformat())
    result_table = RESULT_TABLE_FORMAT.format(suffix=table_suffix)

    return make_job(
        job, result_table,
        creation_start, creation_finish,
        show_start, show_finish
    )


def main():
    cli.run()


if __name__ == "__main__":
    main()
