import argparse
import os


class DbPasswordAbsentError(RuntimeError):
    def __init__(self):
        super().__init__("DB password must be specified by the DB_PASSWORD environment variable.")


def get_parser():
    parser = argparse.ArgumentParser()

    yt_group = parser.add_argument_group(
        "YT arguments",
        "To connect to YT the token must be specified by the `YT_TOKEN` "
        "environment variable or '~/.yt/token' file."
    )
    yt_group.add_argument(
        "--yt-dir",
        help="Directory for dumps.",
        required=True
    )
    yt_group.add_argument(
        "--ttl-minutes",
        help="How long store old tables in minutes, default = 4320 (3 days).",
        default=4320,
        type=int)

    db_group = parser.add_argument_group(
        "DB arguments",
        "DB password must be specified by the `DB_PASSWORD` environment variable."
    )
    db_group.add_argument(
        "--db-username",
        help="User name to connect to the DB.",
        required=True
    )
    db_group.add_argument(
        "--db-host",
        help="Host where DB is located.",
        required=True
    )
    db_group.add_argument(
        "--db-port",
        help="Port to connect to the DB.",
        required=True
    )
    db_group.add_argument(
        "--db-name",
        help="DB name.",
        required=True
    )

    return parser


def get_connection_string(args):
    db_password = os.getenv("DB_PASSWORD")
    if db_password is None:
        raise DbPasswordAbsentError

    return "postgresql://{}:{}@{}:{}/{}".format(
        args.db_username,
        db_password,
        args.db_host,
        args.db_port,
        args.db_name
    )


def parse_args():
    return get_parser().parse_args()
