import json
import typing as tp

from nile.api.v1 import (
    clusters,
    cli,
    Job,
)
import yt.wrapper as yt

import maps.wikimap.stat.fbapi_feedback_metrics.calculate_meta.lib.build_graph as build_graph


JOB_OPTIONS = [
    cli.Option(
        "metrics-dir",
        help="Source directory with calculated metrics.",
        required=False,
    ),
    cli.Option(
        "meta-dir",
        help="Directory with meta tables, containing unique values of each dimension.",
        required=False,
    ),
    cli.Option(
        "blacklist",
        help="Dimensions values to filter out in json format. "
             "Keys are dimensions names, values - lists of values to filter out.",
        required=False,
    ),
]


@cli.statinfra_job(options=JOB_OPTIONS)
def make_job(job: Job, options) -> Job:
    """
    This script calculates meta tables with unique values of each dimension.
    The purpose of these meta tables is to avoid many SELECT DISCTINCT queries
    coming from the Datalens dashboard into CHYT clique each time when
    Datalens dashboard is built. The script does the same SELECT DISTINCT queries
    only once and stores results in meta tables. The script must be executed each time
    after metrics are calculated to keep dimensions values up-to-date.
    """
    cluster = clusters.yql.Hahn()
    yt.config.set_proxy(cluster.proxy)

    blacklist: tp.Dict[str, tp.List[str]] = json.loads(options.blacklist) if options.blacklist else {}
    build_graph.make_job(job, options.metrics_dir, options.meta_dir, blacklist)
    return job


def main() -> None:
    cli.run()


if __name__ == "__main__":
    main()
