import typing as tp


MEMORY_LIMIT: int = 512
ALL_DIMENSIONS: tp.List[str] = [
    "window_days",
    "fielddate",
    "region_name",
    "form_id",
    "client_id",
    "form_type",
    "form_context_id",
    "client_context_id",
    "question_id",
    "answer_id",
    "type",
]

FORMS_METRICS_DIMENSIONS: tp.List[str] = [
    "window_days",
    "fielddate",
    "form_id",
    "client_id",
    "form_type",
    "form_context_id",
    "client_context_id",
]

USERS_METRICS_DIMENSIONS: tp.List[str] = [
    "fielddate",
    "window_days",
    "region_name",
]

EXPERIMENTS_DIMENSIONS: tp.List[str] = ALL_DIMENSIONS + ["test_id"]

REJECT_REASONS: tp.List[str] = [
    "auto-clean-web",
    "incorrect-data",
    "no-data",
    "no-info",
    "no-process",
    "prohibited-by-rules",
    "redirect-to-content-auto",
    "redirect-to-content-bicycle",
    "redirect-to-content-big-task",
    "redirect-to-content-masstransit",
    "redirect-to-content-other",
    "redirect-to-content-pedestrian",
    "redirect-to-content-road-events",
    "redirect-to-content-toponym",
    "redirect-to-content-truck",
    "redirect-to-platform-auto",
    "redirect-to-platform-bicycle",
    "redirect-to-platform-masstransit",
    "redirect-to-platform-toponym",
    "redirect-to-platform-truck",
    "redirect-to-sprav",
    "redirect-to-support",
    "spam",
]

NULL_KEY = "null"

FEEDBACK_METRICS_TYPE = "feedback"
FORMS_METRICS_TYPE = "forms"
USERS_METRICS_TYPE = "users"
EXPERIMENTS_METRICS_TYPE = "experiments"
