def compare_records_lists(list1, list2, eps=1e-10):
    assert len(list1) == len(list2), (
        "Records lists\n{}\nand\n{}\nhave different "
        "lengths".format("\n".join(map(str, list1)), "\n".join(map(str, list2)))
    )
    for rec1, rec2 in zip(list1, list2):
        rec1dict = rec1.to_frozen_dict()
        rec2dict = rec2.to_frozen_dict()
        assert len(rec1dict) == len(rec2dict), (
            f"Records lists have different records\n"
            f"{rec1}\nand\n{rec2}"
        )
        for key, value1 in rec1dict.items():
            value2 = rec2.get(key)
            error = (
                f"Records lists have different records\n"
                f"{rec1}\nand\n{rec2}\nat key {key}: {value1} != {value2}"
            )
            if isinstance(value1, float):
                assert isinstance(value2, float), error
                assert abs(value2 - value1) < eps, error
            else:
                assert value1 == value2, error
