import pytest

from nile.api.v1 import clusters

from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.lib.build_graph import make_job


@pytest.fixture
def job():
    cluster = clusters.MockYQLCluster()
    job = cluster.job()
    make_job(
        job,
        from_date="2021-07-06",
        to_date="2021-07-07",
        nmaps_from_fbapi_dump_date="2021-07-07",
        result_path="",
        windows_days=[1, 3],
        use_bebr=True)
    return job


@pytest.fixture
def original_task():
    return {
        b"form_id": b"toponym",
        b"form_type": b"address/add",
        b"question_id": b"add_object",
        b"answer_id": b"entrance",
        b"form_point": {
            b"lat": b"54.762815383874596",
            b"lon": b"20.50345012588695"
        },
        b"metadata": {
            b"client_id": b"touch-maps",
            b"device_id": b"D370C670-14B4-4D39-A385-F27CA8903842",
            b"locale": b"ru_RU",
            b"uid": 484069442,
            b"uuid": b"af6f076180cbf98b64f031f4e2aedc42",
            b"yandexuid": b"3849595951601369542",
        },
        b"form_context_id": b"toponym.push_notifications",
        b"form_context": {
            b"client_context_id": b"toponym.building"
        }
    }
