from nile.api.v1 import local, Record
from qb2.api.v1 import typing as qt

from maps.wikimap.stat.libs.common.lib import geobase_region

from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.tests.common import compare_records_lists


geobase_region.init_geodata_from_resource()


FEEDBACK_SCHEMA = {
    "id": str,
    "status": str,
    "original_task": qt.Yson,
    "created_at": str,
}

FEEDBACK_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        original_task={
            b"form_id": b"toponym",
            b"form_type": b"address/add",
            b"question_id": b"add_object",
            b"answer_id": b"toponym",
            b"form_point": {
                b"lat": b"54.762815383874596",
                b"lon": b"20.50345012588695"
            },
            b"metadata": {
                b"client_id": b"touch-maps",
            },
            b"form_context_id": b"toponym.push_notifications",
            b"form_context": {
                b"client_context_id": b"toponym.building"
            }
        },
        created_at="2021-01-01T19:51:28.773797+03:00",
    ),
]

REGIONS_SCHEMA = {
    "region_id": str,
    "region_name": str,
    "region_tree": str,
}

REGIONS_TABLE = [
    Record(
        region_id="22",
        region_name="Земля/Россия/Северо-Западный федеральный округ/"
                    "Калининградская область/Калининград",
        region_tree="\t10000\t225\t17\t10857\t22\t",
    ),
]

FEEDBACK_WITH_REGIONS_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        original_task={
            b"form_id": b"toponym",
            b"form_type": b"address/add",
            b"question_id": b"add_object",
            b"answer_id": b"toponym",
            b"form_point": {
                b"lat": b"54.762815383874596",
                b"lon": b"20.50345012588695"
            },
            b"metadata": {
                b"client_id": b"touch-maps",
            },
            b"form_context_id": b"toponym.push_notifications",
            b"form_context": {
                b"client_context_id": b"toponym.building"
            }
        },
        created_at="2021-01-01T19:51:28.773797+03:00",
        region_id="22",
        region_name="Земля\tРоссия\tСеверо-Западный федеральный округ\t"
                    "Калининградская область\tКалининград",
        region_tree="\t10000\t225\t17\t10857\t22\t",
    ),
]


def test_extract_regions(job):
    feedback_with_regions_table = []
    job.local_run(
        sources={
            "feedback_table": local.StreamSource(FEEDBACK_TABLE, FEEDBACK_SCHEMA),
            "regions_table": local.StreamSource(REGIONS_TABLE, REGIONS_SCHEMA),
        },
        sinks={
            "feedback_with_regions_table": local.ListSink(feedback_with_regions_table),
        },
    )
    compare_records_lists(
        sorted(feedback_with_regions_table),
        sorted(FEEDBACK_WITH_REGIONS_TABLE))
