from nile.api.v1 import local, Record
from qb2.api.v1 import typing as qt

from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.tests.common import compare_records_lists


FORMS_METRICS_SCHEMA = {
    "fielddate": str,
    "form_id": str,
    "client_id": str,
    "form_type": str,
    "form_context_id": str,
    "client_context_id": str,
    "forms_shows": qt.Optional[qt.Int32],
    "forms_submits": qt.Optional[qt.Int32],
}

RECORD_DATA = {
    "form_id": "toponym",
    "client_id": "desktop-maps",
    "form_type": "entrance/add",
    "form_context_id": "user_profile.edit_map",
    "client_context_id": "null",
}

FORMS_METRICS_TABLE = [
    Record(
        fielddate="2021-07-05",
        **RECORD_DATA,
        forms_shows=1,
        forms_submits=None,
    ),
    Record(
        fielddate="2021-07-07",
        **RECORD_DATA,
        forms_shows=None,
        forms_submits=1,
    ),
]

FORMS_METRICS_WITH_WINDOWS_TABLE = [
    Record(
        fielddate="2021-07-06",
        **RECORD_DATA,
        window_days=3,
        forms_shows=1,
        forms_submits=None,
    ),
    Record(
        fielddate="2021-07-07",
        **RECORD_DATA,
        window_days=1,
        forms_shows=None,
        forms_submits=1,
    ),
    Record(
        fielddate="2021-07-07",
        **RECORD_DATA,
        window_days=3,
        forms_shows=1,
        forms_submits=1,
    ),
]


def test_aggregate_forms_metrics_in_windows(job):
    forms_metrics_with_windows = []
    job.local_run(
        sources={
            "forms_metrics": local.StreamSource(
                FORMS_METRICS_TABLE,
                FORMS_METRICS_SCHEMA),
        },
        sinks={
            "forms_metrics_with_windows": local.ListSink(forms_metrics_with_windows),
        },
    )
    compare_records_lists(
        sorted(forms_metrics_with_windows),
        sorted(FORMS_METRICS_WITH_WINDOWS_TABLE))
