from nile.api.v1 import local, Record

from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.tests.common import compare_records_lists


FEEDBACK_NON_ANNOTATED_DATES_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-07-05T09:16:25+03:00",
        resolved_at="2021-07-06T09:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
    ),
    Record(
        id="0002d95b-898b-e9df-3365-97afde21f0ed",
        status="accepted",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at=None,
        published_at="2021-07-07T11:16:25+03:00",
        need_info_at="2021-07-07T10:16:25+03:00",
        un_need_info_at="2021-07-07T11:16:25+03:00",
    ),
]

FEEDBACK_ANNOTATED_DATES_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-07-05T09:16:25+03:00",
        resolved_at="2021-07-06T09:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
        fielddate="2021-07-06",
        window_start="2021-07-06",
        window_end="2021-07-07",
        window_days=1,
    ),
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-07-05T09:16:25+03:00",
        resolved_at="2021-07-06T09:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
        fielddate="2021-07-06",
        window_start="2021-07-04",
        window_end="2021-07-07",
        window_days=3,
    ),
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-07-05T09:16:25+03:00",
        resolved_at="2021-07-06T09:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
        fielddate="2021-07-07",
        window_start="2021-07-05",
        window_end="2021-07-08",
        window_days=3,
    ),

    Record(
        id="0002d95b-898b-e9df-3365-97afde21f0ed",
        status="accepted",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at=None,
        published_at="2021-07-07T11:16:25+03:00",
        need_info_at="2021-07-07T10:16:25+03:00",
        un_need_info_at="2021-07-07T11:16:25+03:00",
        fielddate="2021-07-07",
        window_start="2021-07-07",
        window_end="2021-07-08",
        window_days=1,
    ),
    Record(
        id="0002d95b-898b-e9df-3365-97afde21f0ed",
        status="accepted",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at=None,
        published_at="2021-07-07T11:16:25+03:00",
        need_info_at="2021-07-07T10:16:25+03:00",
        un_need_info_at="2021-07-07T11:16:25+03:00",
        fielddate="2021-07-07",
        window_start="2021-07-05",
        window_end="2021-07-08",
        window_days=3,
    ),
]


def test_annotate_with_dates(job):
    full_feedback_data = []
    job.local_run(
        sources={
            "feedback_with_nmaps_data_table": local.StreamSource(FEEDBACK_NON_ANNOTATED_DATES_TABLE),
        },
        sinks={
            "full_feedback_data": local.ListSink(full_feedback_data),
        },
    )
    compare_records_lists(
        sorted(full_feedback_data),
        sorted(FEEDBACK_ANNOTATED_DATES_TABLE))
