from nile.api.v1 import local, Record
from qb2.api.v1 import typing as qt

from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.tests.common import (
    compare_records_lists,
)
from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.lib.forms_metrics import extract_form_type_from_path


PREPARED_BEBR_DATA_SCHEMA = {
    "log_date": str,
    "path": bytes,
    "event_type": str,
    "vars": qt.Yson,
}

PREPARED_BEBR_DATA_TABLE = [
    # Path does not match the pattern maps_www.(feedback|ugc_profile).
    Record(
        log_date="2021-07-06",
        path=b"maps_www.timing.react",
        event_type="show",
        vars={},
    ),

    # Bebr logs in old format.
    Record(
        log_date="2021-07-06",
        path=b"maps_www.feedback.entrance_add",
        event_type="show",
        vars={
            b"clientId": b"desktop-maps",
            b"formContextId": b"user_profile.edit_map",
            b"formId": b"toponym",
            b"formType": b"entrance/add",
        },
    ),
    Record(
        log_date="2021-07-07",
        path=b"maps_www.feedback.organization_add",
        event_type="submit",
        vars={
            b"clientId": b"desktop-maps",
            b"formContextId": b"map.controls",
            b"formId": b"organization",
            b"formType": b"organization/add",
        },
    ),

    # Bebr logs in new format.
    Record(
        log_date="2021-07-06",
        path=b"maps_www.feedback.object_not_found",
        event_type="show",
        vars={
            b"clientId": b"desktop-maps",
            b"formContextId": b"map.context",
            b"formId": b"toponym",
            b"formType": b"object/not-found",
            b"type": b"show",
        },
    ),
    Record(
        log_date="2021-07-07",
        path=b"maps_www.feedback.route_incorrect_road_closed",
        event_type="click",
        vars={
            b"clientId": b"desktop-maps",
            b"formContextId": b"route.detailed_info",
            b"formId": b"route",
            b"formType": b"route/incorrect/road-closed",
            b"routeSessionId": b"r:513d11b0-be1f-415a-bc3e-96b4482b414a",
            b"type": b"submit_button",
        },
    ),

    # Old formContext instead of formContextId.
    Record(
        log_date="2021-07-07",
        path=b"maps_www.feedback.address_add",
        event_type="submit",
        vars={
            b"clientId": b"desktop-maps",
            b"formContext": b"map_controls",
            b"formId": b"toponym",
            b"formType": b"address/add",
        }
    ),

    # Missing keys in vars.
    Record(
        log_date="2021-07-07",
        path=b"maps_www.feedback.route_incorrect_road_closed",
        event_type="submit",
        vars={
            b"clientId": b"desktop-maps",
        },
    ),
    Record(
        log_date="2021-07-07",
        path=b"maps_www.feedback.route_incorrect_obstruction",
        event_type="submit",
        vars={
            b"clientId": b"desktop-maps",
        },
    ),
]

FORMS_METRICS_TABLE = [
    Record(
        fielddate="2021-07-06",
        form_id="toponym",
        client_id="desktop-maps",
        form_type="entrance/add",
        form_context_id="user_profile.edit_map",
        client_context_id="null",
        forms_shows=1,
        forms_submits=None,
    ),
    Record(
        fielddate="2021-07-07",
        form_id="organization",
        client_id="desktop-maps",
        form_type="organization/add",
        form_context_id="map.controls",
        client_context_id="null",
        forms_shows=None,
        forms_submits=1,
    ),
    Record(
        fielddate="2021-07-06",
        form_id="toponym",
        client_id="desktop-maps",
        form_type="object/not-found",
        form_context_id="map.context",
        client_context_id="null",
        forms_shows=1,
        forms_submits=None,
    ),
    Record(
        fielddate="2021-07-07",
        form_id="route",
        client_id="desktop-maps",
        form_type="route/incorrect/road-closed",
        form_context_id="route.detailed_info",
        client_context_id="null",
        forms_shows=None,
        forms_submits=1,
    ),
    Record(
        fielddate="2021-07-07",
        form_id="toponym",
        client_id="desktop-maps",
        form_type="address/add",
        form_context_id="map_controls",
        client_context_id="null",
        forms_shows=None,
        forms_submits=1,
    ),
    Record(
        fielddate="2021-07-07",
        form_id="route",
        client_id="desktop-maps",
        form_type="route/incorrect",
        form_context_id="null",
        client_context_id="null",
        forms_shows=None,
        forms_submits=2,
    ),
]


def test_calculate_daily_forms_metrics(job):
    forms_metrics = []
    job.local_run(
        sources={
            "prepared_bebr_data": local.StreamSource(
                PREPARED_BEBR_DATA_TABLE,
                PREPARED_BEBR_DATA_SCHEMA),
        },
        sinks={
            "forms_metrics": local.ListSink(forms_metrics),
        },
    )
    compare_records_lists(
        sorted(forms_metrics),
        sorted(FORMS_METRICS_TABLE))


def test_extract_form_type_from_path():
    assert extract_form_type_from_path("maps_www.feedback.entrance_add") == "entrance/add"

    assert extract_form_type_from_path("maps_www.feedback.object_not_found") == "object/not-found"
    assert extract_form_type_from_path("maps_www.feedback.organization_edit_status") == "organization/edit-status"
    assert extract_form_type_from_path("maps_www.feedback.organization_edit_info") == "organization/edit-info"

    assert extract_form_type_from_path("maps_www.feedback.route_incorrect_road_closed") == "route/incorrect"
    assert extract_form_type_from_path("maps_www.feedback.route_incorrect_prohibiting-sign") == "route/incorrect"
