from nile.api.v1 import local, Record
from qb2.api.v1 import typing as qt

from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.tests.common import compare_records_lists
from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.lib.constants import ALL_DIMENSIONS, REJECT_REASONS


FEEDBACK_ANNOTATED_DATES_SCHEMA = {
    dimension: qt.Optional[qt.Unicode]
    for dimension in ALL_DIMENSIONS
}
FEEDBACK_ANNOTATED_DATES_SCHEMA.update({
    "fielddate": str,
    "window_start": str,
    "window_end": str,
    "window_days": qt.Int32,

    "created_at": qt.Optional[qt.Unicode],
    "published_at": qt.Optional[qt.Unicode],
    "resolved_at": qt.Optional[qt.Unicode],
    "need_info_at": qt.Optional[qt.Unicode],
    "un_need_info_at": qt.Optional[qt.Unicode],

    "commit_ids": qt.Yson,
    "reject_reason": qt.Optional[qt.Unicode],
    "status": str,
    "some_user_id": qt.Optional[qt.Unicode],
})

FEEDBACK_ANNOTATED_DATES_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-07-05T09:16:25+03:00",
        resolved_at="2021-07-06T09:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
        commit_ids=[47947378],
        reject_reason=None,
        fielddate="2021-07-06",
        window_start="2021-07-06",
        window_end="2021-07-07",
        window_days=1,
        some_user_id="1",
    ),
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-07-05T09:16:25+03:00",
        resolved_at="2021-07-06T09:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
        commit_ids=[47947378],
        reject_reason=None,
        fielddate="2021-07-06",
        window_start="2021-07-04",
        window_end="2021-07-07",
        window_days=3,
        some_user_id="2",
    ),
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-07-05T09:16:25+03:00",
        resolved_at="2021-07-06T09:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
        commit_ids=[47947378],
        reject_reason=None,
        fielddate="2021-07-07",
        window_start="2021-07-05",
        window_end="2021-07-08",
        window_days=3,
        some_user_id="3",
    ),

    Record(
        id="0002d95b-898b-e9df-3365-97afde21f0ed",
        status="accepted",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at=None,
        published_at="2021-07-07T11:16:25+03:00",
        need_info_at=None,
        un_need_info_at=None,
        commit_ids=[],
        reject_reason=None,
        fielddate="2021-07-07",
        window_start="2021-07-07",
        window_end="2021-07-08",
        window_days=1,
        some_user_id="4",
    ),
    Record(
        id="0002d95b-898b-e9df-3365-97afde21f0ed",
        status="accepted",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at=None,
        published_at="2021-07-07T11:16:25+03:00",
        need_info_at=None,
        un_need_info_at=None,
        commit_ids=[],
        reject_reason=None,
        fielddate="2021-07-07",
        window_start="2021-07-05",
        window_end="2021-07-08",
        window_days=3,
        some_user_id="5",
    ),

    Record(
        id="000001a5-f164-29af-1832-a07d5567b1d2",
        status="rejected",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at="2021-07-07T11:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at="2021-07-07T11:16:25+03:00",
        commit_ids=None,
        reject_reason="redirect-to-support",
        fielddate="2021-07-07",
        window_start="2021-07-05",
        window_end="2021-07-08",
        window_days=3,
        some_user_id="6",
    ),

    Record(
        id="000107ca-3234-4d3d-8e46-1ab3cb59ff42",
        status="rejected",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at="2021-07-07T11:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
        commit_ids=None,
        reject_reason="unknown-reject-reason",
        fielddate="2021-07-07",
        window_start="2021-07-05",
        window_end="2021-07-08",
        window_days=3,
        some_user_id="6",
    ),

    Record(
        id="0000b4e5-5e23-4cd8-91af-23a92540e5f6",
        status="need_info",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at=None,
        published_at=None,
        need_info_at="2021-07-07T11:16:25+03:00",
        un_need_info_at=None,
        commit_ids=None,
        reject_reason=None,
        fielddate="2021-07-07",
        window_start="2021-07-05",
        window_end="2021-07-08",
        window_days=3,
        some_user_id="6",
    ),
]

NONE_FIELDS = {
    dimension: None
    for dimension in ALL_DIMENSIONS if dimension not in ("fielddate", "window_days")
}
NONE_FIELDS.update({
    f"reject_reason_{reject_reason.replace('-', '_')}": None
    for reject_reason in REJECT_REASONS if reject_reason != "redirect-to-support"
})

FEEDBACK_METRICS_TABLE = [
    Record(
        **NONE_FIELDS,
        fielddate="2021-07-06",
        window_days=1,
        created=None,
        resolved=1,
        published=None,
        need_info=None,
        un_need_info_at=None,
        resolved_accepted=1,
        resolved_rejected=None,
        resolved_with_commit=1,

        reject_no_reason=None,
        reject_reason_redirect_to_support=None,
        reject_unknown_reason=None,
    ),
    Record(
        **NONE_FIELDS,
        fielddate="2021-07-06",
        window_days=3,
        created=1,
        resolved=1,
        published=None,
        need_info=None,
        un_need_info_at=None,
        resolved_accepted=1,
        resolved_rejected=None,
        resolved_with_commit=1,

        reject_no_reason=None,
        reject_reason_redirect_to_support=None,
        reject_unknown_reason=None,
    ),
    Record(
        **NONE_FIELDS,
        fielddate="2021-07-07",
        window_days=1,
        created=1,
        resolved=None,
        published=1,
        need_info=None,
        un_need_info_at=None,
        resolved_accepted=None,
        resolved_rejected=None,
        resolved_with_commit=None,

        reject_no_reason=None,
        reject_reason_redirect_to_support=None,
        reject_unknown_reason=None,
    ),
    Record(
        **NONE_FIELDS,
        fielddate="2021-07-07",
        window_days=3,
        created=5,
        resolved=3,
        published=1,
        need_info=1,
        un_need_info=1,
        resolved_accepted=1,
        resolved_rejected=2,
        resolved_with_commit=1,

        reject_no_reason=None,
        reject_reason_redirect_to_support=1,
        reject_unknown_reason=1,
    ),
]


def test_calculate_feedback_metrics(job):
    feedback_metrics = []
    job.local_run(
        sources={
            "full_feedback_data": local.StreamSource(
                FEEDBACK_ANNOTATED_DATES_TABLE,
                FEEDBACK_ANNOTATED_DATES_SCHEMA),
        },
        sinks={
            "feedback_metrics": local.ListSink(feedback_metrics),
        },
    )
    compare_records_lists(
        sorted(feedback_metrics),
        sorted(FEEDBACK_METRICS_TABLE))
