from nile.api.v1 import local, Record
from qb2.api.v1 import typing as qt

from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.tests.common import compare_records_lists
from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.lib.constants import ALL_DIMENSIONS


FEEDBACK_ANNOTATED_DATES_SCHEMA = {
    dimension: qt.Optional[qt.Unicode]
    for dimension in ALL_DIMENSIONS
}
FEEDBACK_ANNOTATED_DATES_SCHEMA.update({
    "fielddate": str,
    "window_start": str,
    "window_end": str,
    "window_days": qt.Int32,

    "created_at": qt.Optional[qt.Unicode],
    "published_at": qt.Optional[qt.Unicode],
    "resolved_at": qt.Optional[qt.Unicode],
    "need_info_at": qt.Optional[qt.Unicode],
    "un_need_info_at": qt.Optional[qt.Unicode],

    "commit_ids": qt.Yson,
    "reject_reason": qt.Optional[qt.Unicode],
    "status": str,
    "some_user_id": qt.Optional[qt.Unicode],
})

FEEDBACK_ANNOTATED_DATES_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-07-05T09:16:25+03:00",
        resolved_at="2021-07-06T09:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
        commit_ids=[47947378],
        reject_reason=None,
        fielddate="2021-07-06",
        window_start="2021-07-06",
        window_end="2021-07-07",
        window_days=1,
        some_user_id="1",
    ),
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-07-05T09:16:25+03:00",
        resolved_at="2021-07-06T09:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
        commit_ids=[47947378],
        reject_reason=None,
        fielddate="2021-07-06",
        window_start="2021-07-04",
        window_end="2021-07-07",
        window_days=3,
        some_user_id="2",
    ),
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-07-05T09:16:25+03:00",
        resolved_at="2021-07-06T09:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
        commit_ids=[47947378],
        reject_reason=None,
        fielddate="2021-07-07",
        window_start="2021-07-05",
        window_end="2021-07-08",
        window_days=3,
        some_user_id="3",
    ),

    Record(
        id="0002d95b-898b-e9df-3365-97afde21f0ed",
        status="accepted",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at=None,
        published_at="2021-07-07T11:16:25+03:00",
        need_info_at=None,
        un_need_info_at=None,
        commit_ids=[],
        reject_reason=None,
        fielddate="2021-07-07",
        window_start="2021-07-07",
        window_end="2021-07-08",
        window_days=1,
        some_user_id="4",
    ),
    Record(
        id="0002d95b-898b-e9df-3365-97afde21f0ed",
        status="accepted",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at=None,
        published_at="2021-07-07T11:16:25+03:00",
        need_info_at=None,
        un_need_info_at=None,
        commit_ids=[],
        reject_reason=None,
        fielddate="2021-07-07",
        window_start="2021-07-05",
        window_end="2021-07-08",
        window_days=3,
        some_user_id="5",
    ),

    Record(
        id="000001a5-f164-29af-1832-a07d5567b1d2",
        status="rejected",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at="2021-07-07T11:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at="2021-07-07T11:16:25+03:00",
        commit_ids=None,
        reject_reason="redirect-to-support",
        fielddate="2021-07-07",
        window_start="2021-07-05",
        window_end="2021-07-08",
        window_days=3,
        some_user_id="6",
    ),

    Record(
        id="000107ca-3234-4d3d-8e46-1ab3cb59ff42",
        status="rejected",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at="2021-07-07T11:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
        commit_ids=None,
        reject_reason="unknown-reject-reason",
        fielddate="2021-07-07",
        window_start="2021-07-05",
        window_end="2021-07-08",
        window_days=3,
        some_user_id="6",
    ),

    Record(
        id="0000b4e5-5e23-4cd8-91af-23a92540e5f6",
        status="need_info",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at=None,
        published_at=None,
        need_info_at="2021-07-07T11:16:25+03:00",
        un_need_info_at=None,
        commit_ids=None,
        reject_reason=None,
        fielddate="2021-07-07",
        window_start="2021-07-05",
        window_end="2021-07-08",
        window_days=3,
        some_user_id="6",
    ),
]

USERS_METRICS_TABLE = [
    Record(
        fielddate="2021-07-06",
        window_days=1,
        region_name=None,

        users_created=None,
        users_resolved=1,
        users_resolved_accepted=1,
        users_resolved_with_commit=1,
    ),
    Record(
        fielddate="2021-07-06",
        window_days=3,
        region_name=None,

        users_created=1,
        users_resolved=1,
        users_resolved_accepted=1,
        users_resolved_with_commit=1,
    ),
    Record(
        fielddate="2021-07-07",
        window_days=1,
        region_name=None,

        users_created=1,
        users_resolved=None,
        users_resolved_accepted=None,
        users_resolved_with_commit=None,
    ),
    Record(
        fielddate="2021-07-07",
        window_days=3,
        region_name=None,

        users_created=3,
        users_resolved=2,
        users_resolved_accepted=1,
        users_resolved_with_commit=1,
    ),
]


def test_calculate_feedback_metrics(job):
    users_metrics = []
    job.local_run(
        sources={
            "full_feedback_data": local.StreamSource(
                FEEDBACK_ANNOTATED_DATES_TABLE,
                FEEDBACK_ANNOTATED_DATES_SCHEMA),
        },
        sinks={
            "users_metrics": local.ListSink(users_metrics),
        },
    )
    compare_records_lists(
        sorted(users_metrics),
        sorted(USERS_METRICS_TABLE))
