from nile.api.v1 import (
    datetime as nd,
)

from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.lib.common import (
    make_datetime, Window, WindowsConfig
)


def test_make_datetime():
    assert make_datetime(None) is None
    assert make_datetime("2021-03-11T13:11:53.371685+03:00") == \
        nd.Datetime.from_iso("2021-03-11T13:11:53")


def test_window():
    window = Window(
        start=nd.Datetime.from_iso("2021-03-11T13:11:53"),
        end=nd.Datetime.from_iso("2021-03-12T00:00:00"))
    assert not window.includes(None)
    assert not window.includes(nd.Datetime.from_iso("2021-03-11T13:11:52"))
    assert not window.includes(nd.Datetime.from_iso("2021-03-12T00:00:00"))
    assert window.includes(nd.Datetime.from_iso("2021-03-11T23:59:59"))


def test_windows_config():
    windows_config = WindowsConfig("2021-07-31", "2021-08-02", [1, 3])
    day = nd.Datetime.from_iso("2021-07-31")

    windows = []
    for window in windows_config.windows():
        windows.append(window)

    assert windows == [
        ("2021-07-31", Window(day, day.next()), 1),
        ("2021-07-31", Window(day.next(offset=-2), day.next()), 3),

        ("2021-08-01", Window(day.next(), day.next(offset=2)), 1),
        ("2021-08-01", Window(day.next(offset=-1), day.next(offset=2)), 3),

        ("2021-08-02", Window(day.next(offset=2), day.next(offset=3)), 1),
        ("2021-08-02", Window(day, day.next(offset=3)), 3),
    ]
