from nile.api.v1 import local, Record
from qb2.api.v1 import typing as qt

from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.tests.common import compare_records_lists


FEEDBACK_CHANGES_SCHEMA = {
    "id": qt.Int32,
    "status": str,
    "created_at": str,
    "task_id":  str,
}

FEEDBACK_CHANGES_PUBLISHED_TABLE = [
    Record(
        id=1,
        status="published",
        created_at="2020-03-26T09:16:25+03:00",
        task_id="0225cc93-6e02-d170-177f-2bf4f655f394",
    ),
]

FEEDBACK_HISTORY_PUBLISHED_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        resolved_at="2020-03-26T09:16:25+03:00",
        published_at="2020-03-26T09:16:25+03:00",
        need_info_at=None,
        un_need_info_at=None,
    ),
]

FEEDBACK_CHANGES_PUBLISHED_AFTER_ACCEPTED_TABLE = [
    Record(
        id=2,
        status="published",
        created_at="2020-03-26T10:16:25+03:00",
        task_id="0225cc93-6e02-d170-177f-2bf4f655f394",
    ),
    Record(
        id=1,
        status="accepted",
        created_at="2020-03-26T09:16:25+03:00",
        task_id="0225cc93-6e02-d170-177f-2bf4f655f394",
    ),
]

FEEDBACK_HISTORY_PUBLISHED_AFTER_ACCEPTED_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        resolved_at="2020-03-26T09:16:25+03:00",
        published_at="2020-03-26T10:16:25+03:00",
        need_info_at=None,
        un_need_info_at=None,
    ),
]

FEEDBACK_CHANGES_IN_PROGRESS_AFTER_REJECT_TABLE = [
    Record(
        id=2,
        status="in_progress",
        created_at="2020-03-26T10:16:25+03:00",
        task_id="0225cc93-6e02-d170-177f-2bf4f655f394",
    ),
    Record(
        id=1,
        status="reject",
        created_at="2020-03-26T09:16:25+03:00",
        task_id="0225cc93-6e02-d170-177f-2bf4f655f394",
    ),
]

FEEDBACK_HISTORY_IN_PROGRESS_AFTER_REJECT_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        resolved_at=None,
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
    ),
]

FEEDBACK_CHANGES_NEED_INFO_TABLE = [
    Record(
        id=1,
        status="need_info",
        created_at="2020-03-26T09:16:25+03:00",
        task_id="0225cc93-6e02-d170-177f-2bf4f655f394",
    ),
]

FEEDBACK_HISTORY_NEED_INFO_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        resolved_at=None,
        published_at=None,
        need_info_at="2020-03-26T09:16:25+03:00",
        un_need_info_at=None,
    ),
]

FEEDBACK_CHANGES_IN_PROGRESS_AFTER_NEED_INFO_TABLE = [
    Record(
        id=2,
        status="in_progress",
        created_at="2020-03-26T10:16:25+03:00",
        task_id="0225cc93-6e02-d170-177f-2bf4f655f394",
    ),
    Record(
        id=1,
        status="need_info",
        created_at="2020-03-26T09:16:25+03:00",
        task_id="0225cc93-6e02-d170-177f-2bf4f655f394",
    ),
]

FEEDBACK_HISTORY_IN_PROGRESS_AFTER_NEED_INFO_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        resolved_at=None,
        published_at=None,
        need_info_at="2020-03-26T09:16:25+03:00",
        un_need_info_at="2020-03-26T10:16:25+03:00",
    ),
]

FEEDBACK_CHANGES_NEED_INFO_TWICE_TABLE = [
    Record(
        id=3,
        status="need_info",
        created_at="2020-03-26T11:16:25+03:00",
        task_id="0225cc93-6e02-d170-177f-2bf4f655f394",
    ),
    Record(
        id=2,
        status="in_progress",
        created_at="2020-03-26T10:16:25+03:00",
        task_id="0225cc93-6e02-d170-177f-2bf4f655f394",
    ),
    Record(
        id=1,
        status="need_info",
        created_at="2020-03-26T09:16:25+03:00",
        task_id="0225cc93-6e02-d170-177f-2bf4f655f394",
    ),
]

FEEDBACK_HISTORY_NEED_INFO_TWICE_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        resolved_at=None,
        published_at=None,
        need_info_at="2020-03-26T11:16:25+03:00",
        un_need_info_at=None,
    ),
]

FEEDBACK_CHANGES_REJECTED_AFTER_ACCEPTED_TABLE = [
    Record(
        id=2,
        status="rejected",
        created_at="2020-03-26T10:16:25+03:00",
        task_id="0225cc93-6e02-d170-177f-2bf4f655f394",
    ),
    Record(
        id=1,
        status="accepted",
        created_at="2020-03-26T09:16:25+03:00",
        task_id="0225cc93-6e02-d170-177f-2bf4f655f394",
    ),
]

FEEDBACK_HISTORY_REJECTED_AFTER_ACCEPTED_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        resolved_at="2020-03-26T10:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
    ),
]


def test_construct_task_history(job):
    def run(table, schema, expected) -> None:
        feedback_history = []
        job.local_run(
            sources={
                "feedback_changes_table": local.StreamSource(table, schema),
            },
            sinks={
                "feedback_history": local.ListSink(feedback_history),
            },
        )
        compare_records_lists(sorted(feedback_history), sorted(expected))

    test_cases = [
        (FEEDBACK_CHANGES_PUBLISHED_TABLE,                   FEEDBACK_HISTORY_PUBLISHED_TABLE),
        (FEEDBACK_CHANGES_PUBLISHED_AFTER_ACCEPTED_TABLE,    FEEDBACK_HISTORY_PUBLISHED_AFTER_ACCEPTED_TABLE),
        (FEEDBACK_CHANGES_IN_PROGRESS_AFTER_REJECT_TABLE,    FEEDBACK_HISTORY_IN_PROGRESS_AFTER_REJECT_TABLE),
        (FEEDBACK_CHANGES_NEED_INFO_TABLE,                   FEEDBACK_HISTORY_NEED_INFO_TABLE),
        (FEEDBACK_CHANGES_IN_PROGRESS_AFTER_NEED_INFO_TABLE, FEEDBACK_HISTORY_IN_PROGRESS_AFTER_NEED_INFO_TABLE),
        (FEEDBACK_CHANGES_NEED_INFO_TWICE_TABLE,             FEEDBACK_HISTORY_NEED_INFO_TWICE_TABLE),
        (FEEDBACK_CHANGES_REJECTED_AFTER_ACCEPTED_TABLE,     FEEDBACK_HISTORY_REJECTED_AFTER_ACCEPTED_TABLE),
    ]

    for input_table, output_table in test_cases:
        run(input_table, FEEDBACK_CHANGES_SCHEMA, output_table)
