from nile.api.v1 import local, Record
from qb2.api.v1 import typing as qt

from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.tests.common import compare_records_lists


FEEDBACK_WITH_REGIONS_SCHEMA = {
    "id": str,
    "status": str,
    "original_task": qt.Yson,
    "created_at": str,
    "region_id": str,
    "region_name": str,
    "region_tree": str,
}

FEEDBACK_WITH_REGIONS_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        original_task={
            b"form_id": b"toponym",
            b"form_type": b"address/add",
            b"form_point": {
                b"lat": b"54.762815383874596",
                b"lon": b"20.50345012588695"
            },
            b"metadata": {
                b"client_id": b"touch-maps",
                b"device_id": b"D370C670-14B4-4D39-A385-F27CA8903842",
                b"locale": b"ru_RU",
                b"uid": 484069442,
                b"uuid": b"af6f076180cbf98b64f031f4e2aedc42",
            },
            b"form_context_id": b"toponym.push_notifications",
            b"form_context": {
                b"client_context_id": b"toponym.building"
            }
        },
        created_at="2021-01-01T19:51:28.773797+03:00",
        region_id="22",
        region_name="Земля\tРоссия\tСеверо-Западный федеральный округ\t"
                    "Калининградская область\tКалининград",
        region_tree="\t10000\t225\t17\t10857\t22\t",
    ),
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        original_task={
            b"form_id": b"organization",
            b"form_type": b"address/add",
            b"question_id": b"add_object",
            b"answer_id": b"entrance",
            b"form_point": {
                b"lat": b"54.762815383874596",
                b"lon": b"20.50345012588695"
            },
            b"metadata": {
                b"yandexuid": b"3849595951601369542",
                b"device_id": b"D370C670-14B4-4D39-A385-F27CA8903842",
            },
        },
        created_at="2021-01-01T19:51:28.773797+03:00",
        region_id="22",
        region_name="Земля\tРоссия\tСеверо-Западный федеральный округ\t"
                    "Калининградская область\tКалининград",
        region_tree="\t10000\t225\t17\t10857\t22\t",
    ),
]

FEEDBACK_WITH_DIMENSIONS_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        original_task={
            b"form_id": b"toponym",
            b"form_type": b"address/add",
            b"form_point": {
                b"lat": b"54.762815383874596",
                b"lon": b"20.50345012588695"
            },
            b"metadata": {
                b"client_id": b"touch-maps",
                b"device_id": b"D370C670-14B4-4D39-A385-F27CA8903842",
                b"locale": b"ru_RU",
                b"uid": 484069442,
                b"uuid": b"af6f076180cbf98b64f031f4e2aedc42",
            },
            b"form_context_id": b"toponym.push_notifications",
            b"form_context": {
                b"client_context_id": b"toponym.building"
            }
        },
        created_at="2021-01-01T19:51:28.773797+03:00",
        region_name="Земля\tРоссия\tСеверо-Западный федеральный округ\t"
                    "Калининградская область\tКалининград",
        form_id="toponym",
        client_id="touch-maps",
        form_type="address/add",
        form_context_id="toponym.push_notifications",
        client_context_id="toponym.building",
        question_id="null",
        answer_id="null",
        type="null",
        some_user_id="484069442",
    ),
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        original_task={
            b"form_id": b"organization",
            b"form_type": b"address/add",
            b"question_id": b"add_object",
            b"answer_id": b"entrance",
            b"form_point": {
                b"lat": b"54.762815383874596",
                b"lon": b"20.50345012588695"
            },
            b"metadata": {
                b"yandexuid": b"3849595951601369542",
                b"device_id": b"D370C670-14B4-4D39-A385-F27CA8903842",
            },
        },
        created_at="2021-01-01T19:51:28.773797+03:00",
        region_name="Земля\tРоссия\tСеверо-Западный федеральный округ\t"
                    "Калининградская область\tКалининград",
        form_id="organization",
        client_id="null",
        form_type="address/add",
        form_context_id="null",
        client_context_id="null",
        question_id="add_object",
        answer_id="entrance",
        type="poi_entrance",
        some_user_id="3849595951601369542",
    ),
]


def test_extract_dimensions_for_filters(job):
    feedback_with_dimensions_table = []
    job.local_run(
        sources={
            "feedback_with_regions_table": local.StreamSource(
                FEEDBACK_WITH_REGIONS_TABLE,
                FEEDBACK_WITH_REGIONS_SCHEMA),
        },
        sinks={
            "feedback_with_dimensions_table": local.ListSink(feedback_with_dimensions_table),
        },
    )
    compare_records_lists(
        sorted(feedback_with_dimensions_table),
        sorted(FEEDBACK_WITH_DIMENSIONS_TABLE))
