from nile.api.v1 import local, Record
from qb2.api.v1 import typing as qt

from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.tests.common import compare_records_lists


FEEDBACK_WITH_DIMENSIONS_SCHEMA = {
    "id": str,
    "status": str,
    "created_at": str,
}

FEEDBACK_WITH_DIMENSIONS_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-01-01T19:51:28.773797+03:00",
    ),
    Record(
        id="0000011c-7df4-4a4c-2a95-34365366b0c5",
        status="need_info",
        created_at="2021-01-01T19:51:28.773797+03:00",
    ),
]

FEEDBACK_HISTORY_SCHEMA = {
    "id": str,
    "resolved_at": qt.Optional[qt.Unicode],
    "published_at": qt.Optional[qt.Unicode],
    "need_info_at": qt.Optional[qt.Unicode],
    "un_need_info_at": qt.Optional[qt.Unicode],
}

FEEDBACK_HISTORY_IN_PROGRESS_AFTER_REJECT_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        resolved_at=None,
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
    ),
]

FEEDBACK_WITH_FIXED_HISTORY_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-01-01T19:51:28.773797+03:00",
        resolved_at="2021-01-01T19:51:28.773797+03:00",
        published_at="2021-01-01T19:51:28.773797+03:00",
        need_info_at=None,
        un_need_info_at=None,
    ),
    Record(
        id="0000011c-7df4-4a4c-2a95-34365366b0c5",
        status="need_info",
        created_at="2021-01-01T19:51:28.773797+03:00",
        resolved_at=None,
        published_at=None,
        need_info_at="2021-01-01T19:51:28.773797+03:00",
        un_need_info_at=None,
    ),
]


def test_fix_missing_history(job):
    feedback_with_fixed_history_table = []
    job.local_run(
        sources={
            "feedback_with_dimensions_table": local.StreamSource(
                FEEDBACK_WITH_DIMENSIONS_TABLE,
                FEEDBACK_WITH_DIMENSIONS_SCHEMA),
            "feedback_history": local.StreamSource(
                FEEDBACK_HISTORY_IN_PROGRESS_AFTER_REJECT_TABLE,
                FEEDBACK_HISTORY_SCHEMA,
            ),
        },
        sinks={
            "feedback_with_fixed_history_table": local.ListSink(feedback_with_fixed_history_table),
        },
    )
    compare_records_lists(
        sorted(feedback_with_fixed_history_table),
        sorted(FEEDBACK_WITH_FIXED_HISTORY_TABLE))
