from nile.api.v1 import local, Record
from qb2.api.v1 import typing as qt

from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.tests.common import compare_records_lists


FEEDBACK_WITH_FIXED_HISTORY_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-07-05T09:16:25+03:00",
        resolved_at="2021-07-06T09:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
        type="null",
    ),
    Record(
        id="0002d95b-898b-e9df-3365-97afde21f0ed",
        status="rejected",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at=None,
        published_at="2021-07-07T11:16:25+03:00",
        need_info_at="2021-07-07T10:16:25+03:00",
        un_need_info_at="2021-07-07T11:16:25+03:00",
        type="poi",
    ),
]

PREPARED_NMAPS_SCHEMA = {
    "id": str,
    "commit_ids": qt.Yson,
    "reject_reason": qt.Optional[qt.Unicode],
    "nmaps_type": qt.Unicode,
}

PREPARED_NMAPS_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        commit_ids=[47947378],
        reject_reason=None,
        nmaps_type="entrance",
    ),
    Record(
        id="6f23ae62-07fa-45ad-b73f-57ee3aa8a2eb",
        commit_ids=None,
        reject_reason="redirect-to-support",
        nmaps_type="address",
    ),
]

FEEDBACK_WITH_NMAPS_DATA_TABLE = [
    Record(
        id="0225cc93-6e02-d170-177f-2bf4f655f394",
        status="published",
        created_at="2021-07-05T09:16:25+03:00",
        resolved_at="2021-07-06T09:16:25+03:00",
        published_at=None,
        need_info_at=None,
        un_need_info_at=None,
        commit_ids=[47947378],
        reject_reason=None,
        type="entrance",
    ),
    Record(
        id="0002d95b-898b-e9df-3365-97afde21f0ed",
        status="rejected",
        created_at="2021-07-07T09:16:25+03:00",
        resolved_at=None,
        published_at="2021-07-07T11:16:25+03:00",
        need_info_at="2021-07-07T10:16:25+03:00",
        un_need_info_at="2021-07-07T11:16:25+03:00",
        commit_ids=None,
        reject_reason=None,
        type="poi",
    ),
]


def test_join_nmaps_data(job):
    feedback_with_nmaps_data_table = []
    job.local_run(
        sources={
            "feedback_with_fixed_history_table": local.StreamSource(
                FEEDBACK_WITH_FIXED_HISTORY_TABLE),
            "prepared_nmaps_table": local.StreamSource(
                PREPARED_NMAPS_TABLE,
                PREPARED_NMAPS_SCHEMA),
        },
        sinks={
            "feedback_with_nmaps_data_table": local.ListSink(feedback_with_nmaps_data_table),
        },
    )
    compare_records_lists(
        sorted(feedback_with_nmaps_data_table),
        sorted(FEEDBACK_WITH_NMAPS_DATA_TABLE))
