from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.lib.original_task import OriginalTask
from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.lib.constants import NULL_KEY


def test_extract_client_id(original_task):
    assert OriginalTask(None).extract_client_id() == NULL_KEY
    assert OriginalTask(original_task).extract_client_id() == "touch-maps"

    original_task[b"metadata"] = dict()
    assert OriginalTask(original_task).extract_client_id() == NULL_KEY

    del original_task[b"metadata"]
    assert OriginalTask(original_task).extract_client_id() == NULL_KEY


def test_extract_client_context_id(original_task):
    assert OriginalTask(None).extract_client_context_id() == NULL_KEY
    assert OriginalTask(original_task).extract_client_context_id() == "toponym.building"

    original_task[b"form_context"] = dict()
    assert OriginalTask(original_task).extract_client_context_id() == NULL_KEY

    del original_task[b"form_context"]
    assert OriginalTask(original_task).extract_client_context_id() == NULL_KEY


def test_extract_some_user_id(original_task):
    assert OriginalTask(None).extract_some_user_id() is None
    assert OriginalTask(original_task).extract_some_user_id() == "484069442"

    del original_task[b"metadata"][b"uid"]
    assert OriginalTask(original_task).extract_some_user_id() == "3849595951601369542"

    del original_task[b"metadata"][b"yandexuid"]
    assert OriginalTask(original_task).extract_some_user_id() == "D370C670-14B4-4D39-A385-F27CA8903842"

    del original_task[b"metadata"][b"device_id"]
    assert OriginalTask(original_task).extract_some_user_id() is None

    original_task[b"metadata"] = dict()
    assert OriginalTask(original_task).extract_some_user_id() is None


def test_extract(original_task):
    empty = OriginalTask(None)
    assert empty.extract(b"form_id") == NULL_KEY
    assert empty.extract(b"form_type") == NULL_KEY
    assert empty.extract(b"form_context_id") == NULL_KEY
    assert empty.extract(b"question_id") == NULL_KEY
    assert empty.extract(b"answer_id") == NULL_KEY

    full = OriginalTask(original_task)
    assert full.extract(b"form_id") == "toponym"
    assert full.extract(b"form_type") == "address/add"
    assert full.extract(b"form_context_id") == "toponym.push_notifications"
    assert full.extract(b"question_id") == "add_object"
    assert full.extract(b"answer_id") == "entrance"
