from nile.api.v1 import local, Record
from qb2.api.v1 import typing as qt

from maps.wikimap.stat.fbapi_feedback_metrics.calculate_metrics.tests.common import compare_records_lists


NMAPS_FROM_FBAPI_FEEDBACK_SCHEMA = {
    "id": qt.UInt64,
    "fbapi_data": qt.Yson,
    "source": qt.Optional[qt.Unicode],
}

NMAPS_FROM_FBAPI_FEEDBACK_TABLE = [
    Record(
        id=41001,
        fbapi_data={
            b"id": b"cf64bfba787341ea84f428ca65f068b9",
        },
        source="fbapi",
    ),
    Record(
        id=41002,
        fbapi_data={
            b"id": b"e3912953371c40b9aff599eb5e9a805b",
        },
    ),
    Record(
        id=41003,
        fbapi_data={
            b"id": b"881f076f323a4a56a89896c0b4439e36",
        },
    ),
]

NMAPS_FEEDBACK_DB_SCHEMA = {
    "id": qt.UInt64,
    "commit_ids": qt.Yson,
    "reject_reason": qt.Optional[qt.String],
    "source": qt.Optional[qt.String],
    "type": qt.Unicode,
}

NMAPS_FEEDBACK_DB_TABLE = [
    Record(
        id=41001,
        commit_ids=[47947438, 47947400, 47947378],
        reject_reason=b"redirect-to-support",
        source=b"fbapi",
        type="entrance",
    ),
    Record(
        id=41003,
        commit_ids=[],
        type="address",
    ),
]

PREPARED_NMAPS_TABLE = [
    Record(
        id="cf64bfba787341ea84f428ca65f068b9",
        nmaps_id=41001,
        commit_ids=[47947438, 47947400, 47947378],
        reject_reason="redirect-to-support",
        nmaps_type="entrance",
    ),
    Record(
        id="881f076f323a4a56a89896c0b4439e36",
        nmaps_id=41003,
        commit_ids=[],
        reject_reason=None,
        nmaps_type="address",
    ),
]


def test_prepare_nmaps_data(job):
    prepared_nmaps_table = []
    job.local_run(
        sources={
            "nmaps_feedback_db_table": local.StreamSource(
                NMAPS_FEEDBACK_DB_TABLE,
                NMAPS_FEEDBACK_DB_SCHEMA),
            "nmaps_from_fbapi_feedback_table": local.StreamSource(
                NMAPS_FROM_FBAPI_FEEDBACK_TABLE,
                NMAPS_FROM_FBAPI_FEEDBACK_SCHEMA),
        },
        sinks={
            "prepared_nmaps_table": local.ListSink(prepared_nmaps_table),
        },
    )
    compare_records_lists(
        sorted(prepared_nmaps_table),
        sorted(PREPARED_NMAPS_TABLE))
