import maps.wikimap.stat.feedback_age.lib.eval_report as eval_report
import maps.wikimap.stat.feedback_age.lib.eval_report_closure as eval_report_closure

from nile.api.v1 import (
    clusters,
    statface as ns
)

import argparse

feedback_report = 'Maps.Wiki/Feedback/AgePercentile'
closures_report = 'Maps.Wiki/Feedback/ClosureAgePercentile'


def main():
    parser = argparse.ArgumentParser(
        description="Use environment variables 'YT_TOKEN' and 'STATFACE_TOKEN' for OAuth authorisation."
    )
    parser.add_argument('--report-type', help='Common feedback or closures', required=True, choices=['feedback', 'closures'])
    parser.add_argument('--from-date', help='Begin date, iso format: 2018-12-31', required=True)
    parser.add_argument('--to-date', help='End date, iso format: 2018-12-31. Equal to begin date if not specified', default='')
    parser.add_argument('--statface-prod', help='Upload to Statface production', action='store_true')
    parser.add_argument('--report', help='Path to report in stat', default='')
    args = parser.parse_args()

    cluster = clusters.yt.Hahn()

    if args.statface_prod:
        statface_client = ns.StatfaceProductionClient()
    else:
        statface_client = ns.StatfaceBetaClient()

    if args.report_type == 'feedback':
        report_path = feedback_report
        make_job = eval_report.make_job
    else:
        report_path = closures_report
        make_job = eval_report_closure.make_job

    if args.report:
        report_path = args.report

    from_date = args.from_date
    if args.to_date:
        to_date = args.to_date
    else:
        to_date = from_date

    job = cluster.job("make-feedback-stat")
    make_job(job, from_date, to_date, report_path, statface_client)
    job.run()


if __name__ == '__main__':
    main()
