from __future__ import print_function

import maps.wikimap.stat.feedback_age.lib.eval_report_closure as eval_report_closure

from common import days_ago_str

from nile.api.v1 import (
    local,
    clusters,
    Record
)


def test_eval_report_closure():
    print('Testing')

    cluster = clusters.MockCluster()
    job = cluster.job()
    job = eval_report_closure.make_testable_job(job, days_ago_str(1), days_ago_str(1))

    relevant = [
        Record(
            age_days=0.5,
            age_days_need_info=None,
            created_at='%s 12:00:00.000000+03' % days_ago_str(1),
            fielddate=days_ago_str(1),
            history=[{'operation': 'reveal', 'modifiedAt': '%s 12:00:00.000000+03' % days_ago_str(1)}],
            need_info_at_end=0,
            need_info_in_window=False,
            open_at_end=1,
            resolved_at='%s 12:10:00.000000+03' % days_ago_str(1),
            source='closure-moving',
            type='road-closure',
            workflow='feedback'
        ),
        Record(
            age_days=0.25,
            age_days_need_info=None,
            created_at='%s 18:00:00.000000+03' % days_ago_str(1),
            fielddate=days_ago_str(1),
            history=[{'operation': 'reveal', 'modifiedAt': '%s 18:00:00.000000+03' % days_ago_str(1)}],
            need_info_at_end=0,
            need_info_in_window=False,
            open_at_end=1,
            resolved_at='%s 18:20:00.000000+03' % days_ago_str(1),
            source='infopoints',
            type='road-closure',
            workflow='feedback'
        ),
        Record(
            age_days=0.125,
            age_days_need_info=None,
            created_at='%s 21:00:00.000000+03' % days_ago_str(1),
            fielddate=days_ago_str(1),
            history=[{'operation': 'reveal', 'modifiedAt': '%s 21:00:00.000000+03' % days_ago_str(1)}],
            need_info_at_end=0,
            need_info_in_window=False,
            open_at_end=1,
            resolved_at='%s 21:40:00.000000+03' % days_ago_str(1),
            source='closure-untied',
            type='road-closure',
            workflow='feedback'
        ),
    ]

    daily_result = []

    job.local_run(
        sources={'relevant': local.StreamSource(relevant)},
        sinks={
            'daily_result': local.ListSink(daily_result)
        }
    )

    assert daily_result == [
        Record(
            fielddate=days_ago_str(1), workflow='feedback',
            max_age_minutes=40.0, percentile_85_age_minutes=34.0, sum_counter=3
        )
    ]
