from __future__ import print_function

import maps.wikimap.stat.feedback_age.lib.eval_report_closure as eval_report_closure

from common import days_ago_str, create_feedback_record

from nile.api.v1 import (
    local,
    clusters,
    Record
)


def test_eval_report_closure_relevant():
    print('Testing')

    cluster = clusters.MockCluster()
    job = cluster.job()
    job = eval_report_closure.make_testable_job(job, days_ago_str(1), days_ago_str(1))

    feedback = [
        # pX: Y1 + (Y2 - Y1) * ((X - X1) / (X2 - X1))
        # p0.85: 20 + (40 - 20) * ((0.85 - 0.5) / (1.0 - 0.5)) = 34.0
        create_feedback_record('12:00:00', 'feed', 'closure-moving', 'road-closure', resolved_at='12:10:00'),
        create_feedback_record('18:00:00', 'feed', 'infopoints',     'road-closure', resolved_at='18:20:00'),
        create_feedback_record('21:00:00', 'feed', 'closure-untied', 'road-closure', resolved_at='21:40:00'),

        # Must be filtered out:
        create_feedback_record('01:00:00', 'feed', 'mrc', 'wrong-parking', resolved_at='06:00:00'),
        create_feedback_record('01:00:00', 'feed', 'mrc', 'wrong-speed-limit', resolved_at='06:00:00'),
        create_feedback_record('01:00:00', 'feed', 'mrc', 'traffic-lane-sign', resolved_at='06:00:00'),
        create_feedback_record('01:00:00', 'task', 'experiment-fbapi', 'address', resolved_at='06:00:00'),
        create_feedback_record('01:00:00', 'task', 'infopoints', 'road-closure'),
    ]

    relevant = []
    daily_result = []

    job.local_run(
        sources={'feedback_db': local.StreamSource(feedback)},
        sinks={
            'relevant': local.ListSink(relevant),
            'daily_result': local.ListSink(daily_result)
        }
    )

    assert relevant == [
        Record(
            age_days=0.5,
            age_days_need_info=None,
            created_at='%s 12:00:00.000000+03' % days_ago_str(1),
            fielddate=days_ago_str(1),
            history=[{'operation': 'reveal', 'modifiedAt': '%s 12:00:00.000000+03' % days_ago_str(1)}],
            need_info_at_end=0,
            need_info_in_window=False,
            open_at_end=1,
            resolved_at='%s 12:10:00.000000+03' % days_ago_str(1),
            source='closure-moving',
            type='road-closure',
            workflow='feedback'
        ),
        Record(
            age_days=0.25,
            age_days_need_info=None,
            created_at='%s 18:00:00.000000+03' % days_ago_str(1),
            fielddate=days_ago_str(1),
            history=[{'operation': 'reveal', 'modifiedAt': '%s 18:00:00.000000+03' % days_ago_str(1)}],
            need_info_at_end=0,
            need_info_in_window=False,
            open_at_end=1,
            resolved_at='%s 18:20:00.000000+03' % days_ago_str(1),
            source='infopoints',
            type='road-closure',
            workflow='feedback'
        ),
        Record(
            age_days=0.125,
            age_days_need_info=None,
            created_at='%s 21:00:00.000000+03' % days_ago_str(1),
            fielddate=days_ago_str(1),
            history=[{'operation': 'reveal', 'modifiedAt': '%s 21:00:00.000000+03' % days_ago_str(1)}],
            need_info_at_end=0,
            need_info_in_window=False,
            open_at_end=1,
            resolved_at='%s 21:40:00.000000+03' % days_ago_str(1),
            source='closure-untied',
            type='road-closure',
            workflow='feedback'
        ),
    ]
