from __future__ import print_function

import maps.wikimap.stat.feedback_age.lib.eval_report as eval_report

from nile.api.v1 import (
    local,
    clusters,
    Record
)


def test_need_info():
    cluster = clusters.MockCluster()
    job = cluster.job()
    job = eval_report.make_testable_job(job, '2020-03-18', '2020-03-28')

    record_dict = {
        'type' : 'address',
        'source' : 'fbapi',
        'workflow' : 'feedback',
        'history' : [{
            "modifiedAt" : "2020-03-19 12:00:00",
            "operation" : "reveal"
        }, {
            "modifiedAt" : "2020-03-19 18:00:00",
            "operation" : "need-info"
        }, {
            "modifiedAt" : "2020-03-20 03:00:00",
            "operation" : "open"
        }, {
            "modifiedAt" : "2020-03-20 09:00:00",
            "operation" : "need-info"
        }, {
            "modifiedAt" : "2020-03-20 12:00:00",
            "operation" : "open"
        }, {
            "modifiedAt" : "2020-03-20 15:00:00",
            "operation" : "need-info"
        }, {
            "modifiedAt" : "2020-03-20 18:00:00",
            "operation" : "open"
        }, {
            "modifiedAt" : "2020-03-21 15:00:00",
            "operation" : "need-info"
        }, {
            "modifiedAt" : "2020-03-23 18:00:00",
            "operation" : "open"
        }, {
            "modifiedAt" : "2020-03-26 12:00:00",
            "operation" : "need-info"
        }, {
            "modifiedAt" : "2020-03-26 18:00:00",
            "operation" : "open"
        }]
    }

    feedback = [Record.from_dict(record_dict)]
    relevant = []
    daily_result = []

    job.local_run(
        sources={'feedback_db': local.StreamSource(feedback)},
        sinks={
            'relevant': local.ListSink(relevant),
            'daily_result': local.ListSink(daily_result),
            }
    )

    assert sorted(daily_result) == sorted([
        Record(
            fielddate='2020-03-19', workflow='feedback',
            max_age_days=0.25, percentile_85_age_days=0.25,
            percentile_99_age_days=0.25, sum_open_now=0,
            max_age_days_need_info=0.25, sum_need_info=1,
            percentile_85_age_days_need_info=0.25,
            percentile_99_age_days_need_info=0.25,
            percentile_low1_age_days_need_info=0.25,
            percentile_low2_age_days_need_info=0.25,
            percentile_low3_age_days_need_info=0.25,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-20', workflow='feedback',
            max_age_days=0.875, percentile_85_age_days=0.875,
            percentile_99_age_days=0.875, sum_open_now=1,
            max_age_days_need_info=0.625, sum_need_info=0,
            percentile_85_age_days_need_info=0.625,
            percentile_99_age_days_need_info=0.625,
            percentile_low1_age_days_need_info=0.625,
            percentile_low2_age_days_need_info=0.625,
            percentile_low3_age_days_need_info=0.625,
            resolved_in_1day_need_info=1,
            resolved_in_30days_need_info=1,
            resolved_in_3days_need_info=1,
            resolved_in_7days_need_info=1,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-21', workflow='feedback',
            max_age_days=1.5, percentile_85_age_days=1.5,
            percentile_99_age_days=1.5, sum_open_now=0,
            max_age_days_need_info=1.0, sum_need_info=1,
            percentile_85_age_days_need_info=1.0,
            percentile_99_age_days_need_info=1.0,
            percentile_low1_age_days_need_info=1.0,
            percentile_low2_age_days_need_info=1.0,
            percentile_low3_age_days_need_info=1.0,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-22', workflow='feedback',
            max_age_days=1.5, percentile_85_age_days=1.5,
            percentile_99_age_days=1.5, sum_open_now=0,
            max_age_days_need_info=2.0, sum_need_info=1,
            percentile_85_age_days_need_info=2.0,
            percentile_99_age_days_need_info=2.0,
            percentile_low1_age_days_need_info=2.0,
            percentile_low2_age_days_need_info=2.0,
            percentile_low3_age_days_need_info=2.0,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-23', workflow='feedback',
            max_age_days=1.75, percentile_85_age_days=1.75,
            percentile_99_age_days=1.75, sum_open_now=1,
            max_age_days_need_info=2.75, sum_need_info=0,
            percentile_85_age_days_need_info=2.75,
            percentile_99_age_days_need_info=2.75,
            percentile_low1_age_days_need_info=2.75,
            percentile_low2_age_days_need_info=2.75,
            percentile_low3_age_days_need_info=2.75,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=1,
            resolved_in_3days_need_info=1,
            resolved_in_7days_need_info=1,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-24', workflow='feedback',
            max_age_days=2.75, percentile_85_age_days=2.75,
            percentile_99_age_days=2.75, sum_open_now=1,
            max_age_days_need_info=2.75, sum_need_info=0,
            percentile_85_age_days_need_info=2.75,
            percentile_99_age_days_need_info=2.75,
            percentile_low1_age_days_need_info=2.75,
            percentile_low2_age_days_need_info=2.75,
            percentile_low3_age_days_need_info=2.75,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-25', workflow='feedback',
            max_age_days=3.75, percentile_85_age_days=3.75,
            percentile_99_age_days=3.75, sum_open_now=1,
            max_age_days_need_info=2.75, sum_need_info=0,
            percentile_85_age_days_need_info=2.75,
            percentile_99_age_days_need_info=2.75,
            percentile_low1_age_days_need_info=2.75,
            percentile_low2_age_days_need_info=2.75,
            percentile_low3_age_days_need_info=2.75,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-26', workflow='feedback',
            max_age_days=4.5, percentile_85_age_days=4.5,
            percentile_99_age_days=4.5, sum_open_now=1,
            max_age_days_need_info=3.0, sum_need_info=0,
            percentile_85_age_days_need_info=3.0,
            percentile_99_age_days_need_info=3.0,
            percentile_low1_age_days_need_info=3.0,
            percentile_low2_age_days_need_info=3.0,
            percentile_low3_age_days_need_info=3.0,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=1,
            resolved_in_3days_need_info=1,
            resolved_in_7days_need_info=1,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-27', workflow='feedback',
            max_age_days=5.5, percentile_85_age_days=5.5,
            percentile_99_age_days=5.5, sum_open_now=1,
            max_age_days_need_info=3.0, sum_need_info=0,
            percentile_85_age_days_need_info=3.0,
            percentile_99_age_days_need_info=3.0,
            percentile_low1_age_days_need_info=3.0,
            percentile_low2_age_days_need_info=3.0,
            percentile_low3_age_days_need_info=3.0,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-28', workflow='feedback',
            max_age_days=6.5, percentile_85_age_days=6.5,
            percentile_99_age_days=6.5, sum_open_now=1,
            max_age_days_need_info=3.0, sum_need_info=0,
            percentile_85_age_days_need_info=3.0,
            percentile_99_age_days_need_info=3.0,
            percentile_low1_age_days_need_info=3.0,
            percentile_low2_age_days_need_info=3.0,
            percentile_low3_age_days_need_info=3.0,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        ),
    ])


def test_need_info_resolved():
    cluster = clusters.MockCluster()
    job = cluster.job()
    job = eval_report.make_testable_job(job, '2020-03-18', '2020-03-22')

    record_dict = {
        'type' : 'address',
        'source' : 'fbapi',
        'workflow' : 'feedback',
        'history' : [{
            "modifiedAt" : "2020-03-19 12:00:00",
            "operation" : "reveal"
        }, {
            "modifiedAt" : "2020-03-19 18:00:00",
            "operation" : "need-info"
        }, {
            "modifiedAt" : "2020-03-20 03:00:00",
            "operation" : "open"
        }, {
            "modifiedAt" : "2020-03-21 15:00:00",
            "operation" : "accept"
        }]
    }

    feedback = [Record.from_dict(record_dict)]
    relevant = []
    daily_result = []

    job.local_run(
        sources={'feedback_db': local.StreamSource(feedback)},
        sinks={
            'relevant': local.ListSink(relevant),
            'daily_result': local.ListSink(daily_result)
        }
    )

    assert sorted(daily_result) == sorted([
        Record(
            fielddate='2020-03-19', workflow='feedback',
            max_age_days=0.25, percentile_85_age_days=0.25,
            percentile_99_age_days=0.25, sum_open_now=0,
            max_age_days_need_info=0.25, sum_need_info=1,
            percentile_85_age_days_need_info=0.25,
            percentile_99_age_days_need_info=0.25,
            percentile_low1_age_days_need_info=0.25,
            percentile_low2_age_days_need_info=0.25,
            percentile_low3_age_days_need_info=0.25,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-20', workflow='feedback',
            max_age_days=1.125, percentile_85_age_days=1.125,
            percentile_99_age_days=1.125, sum_open_now=1,
            max_age_days_need_info=0.375, sum_need_info=0,
            percentile_85_age_days_need_info=0.375,
            percentile_99_age_days_need_info=0.375,
            percentile_low1_age_days_need_info=0.375,
            percentile_low2_age_days_need_info=0.375,
            percentile_low3_age_days_need_info=0.375,
            resolved_in_1day_need_info=1,
            resolved_in_30days_need_info=1,
            resolved_in_3days_need_info=1,
            resolved_in_7days_need_info=1,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-21', workflow='feedback',
            max_age_days=1.75, percentile_85_age_days=1.75,
            percentile_99_age_days=1.75, sum_open_now=0,
            max_age_days_need_info=0.375, sum_need_info=0,
            percentile_85_age_days_need_info=0.375,
            percentile_99_age_days_need_info=0.375,
            percentile_low1_age_days_need_info=0.375,
            percentile_low2_age_days_need_info=0.375,
            percentile_low3_age_days_need_info=0.375,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        ),
    ])


def test_need_info_deployed():
    cluster = clusters.MockCluster()
    job = cluster.job()
    job = eval_report.make_testable_job(job, '2020-03-18', '2020-03-22')

    record_dict = {
        'type' : 'address',
        'source' : 'fbapi',
        'workflow' : 'feedback',
        'history' : [{
            "modifiedAt" : "2020-03-19 12:00:00",
            "operation" : "reveal"
        }, {
            "modifiedAt" : "2020-03-19 18:00:00",
            "operation" : "need-info"
        }, {
            "modifiedAt" : "2020-03-20 03:00:00",
            "operation" : "open"
        }, {
            "modifiedAt" : "2020-03-21 15:00:00",
            "operation" : "accept"
        }, {
            "modifiedAt" : "2020-03-21 18:00:00",
            "operation" : "deploy"
        }]
    }

    feedback = [Record.from_dict(record_dict)]
    relevant = []
    daily_result = []

    job.local_run(
        sources={'feedback_db': local.StreamSource(feedback)},
        sinks={
            'relevant': local.ListSink(relevant),
            'daily_result': local.ListSink(daily_result)
        }
    )

    assert sorted(daily_result) == sorted([
        Record(
            fielddate='2020-03-19', workflow='feedback',
            max_age_days=0.25, percentile_85_age_days=0.25,
            percentile_99_age_days=0.25, sum_open_now=0,
            max_age_days_need_info=0.25, sum_need_info=1,
            percentile_85_age_days_need_info=0.25,
            percentile_99_age_days_need_info=0.25,
            percentile_low1_age_days_need_info=0.25,
            percentile_low2_age_days_need_info=0.25,
            percentile_low3_age_days_need_info=0.25,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-20', workflow='feedback',
            max_age_days=1.125, percentile_85_age_days=1.125,
            percentile_99_age_days=1.125, sum_open_now=1,
            max_age_days_need_info=0.375, sum_need_info=0,
            percentile_85_age_days_need_info=0.375,
            percentile_99_age_days_need_info=0.375,
            percentile_low1_age_days_need_info=0.375,
            percentile_low2_age_days_need_info=0.375,
            percentile_low3_age_days_need_info=0.375,
            resolved_in_1day_need_info=1,
            resolved_in_30days_need_info=1,
            resolved_in_3days_need_info=1,
            resolved_in_7days_need_info=1,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-21', workflow='feedback',
            max_age_days=1.75, percentile_85_age_days=1.75,
            percentile_99_age_days=1.75, sum_open_now=0,
            max_age_days_need_info=0.375, sum_need_info=0,
            percentile_85_age_days_need_info=0.375,
            percentile_99_age_days_need_info=0.375,
            percentile_low1_age_days_need_info=0.375,
            percentile_low2_age_days_need_info=0.375,
            percentile_low3_age_days_need_info=0.375,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        ),
    ])


def test_need_info_reopened():
    cluster = clusters.MockCluster()
    job = cluster.job()
    job = eval_report.make_testable_job(job, '2020-03-18', '2020-03-23')

    record_dict = {
        'type' : 'address',
        'source' : 'fbapi',
        'workflow' : 'feedback',
        'history' : [{
            "modifiedAt" : "2020-03-19 12:00:00",
            "operation" : "reveal"
        }, {
            "modifiedAt" : "2020-03-19 15:00:00",
            "operation" : "accept"
        }, {
            "modifiedAt" : "2020-03-19 18:00:00",
            "operation" : "need-info"
        }, {
            "modifiedAt" : "2020-03-20 03:00:00",
            "operation" : "open"
        }, {
            "modifiedAt" : "2020-03-21 15:00:00",
            "operation" : "accept"
        }, {
            "modifiedAt" : "2020-03-23 18:00:00",
            "operation" : "open"
        }]
    }

    feedback = [Record.from_dict(record_dict)]
    relevant = []
    daily_result = []

    job.local_run(
        sources={'feedback_db': local.StreamSource(feedback)},
        sinks={
            'relevant': local.ListSink(relevant),
            'daily_result': local.ListSink(daily_result)
        }
    )

    assert sorted(daily_result) == sorted([
        Record(
            fielddate='2020-03-19', workflow='feedback',
            max_age_days=0.125, percentile_85_age_days=0.125,
            percentile_99_age_days=0.125, sum_open_now=0,
            max_age_days_need_info=0.25, sum_need_info=1,
            percentile_85_age_days_need_info=0.25,
            percentile_99_age_days_need_info=0.25,
            percentile_low1_age_days_need_info=0.25,
            percentile_low2_age_days_need_info=0.25,
            percentile_low3_age_days_need_info=0.25,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-20', workflow='feedback',
            max_age_days=0.875, percentile_85_age_days=0.875,
            percentile_99_age_days=0.875, sum_open_now=1,
            max_age_days_need_info=0.375, sum_need_info=0,
            percentile_85_age_days_need_info=0.375,
            percentile_99_age_days_need_info=0.375,
            percentile_low1_age_days_need_info=0.375,
            percentile_low2_age_days_need_info=0.375,
            percentile_low3_age_days_need_info=0.375,
            resolved_in_1day_need_info=1,
            resolved_in_30days_need_info=1,
            resolved_in_3days_need_info=1,
            resolved_in_7days_need_info=1,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-21', workflow='feedback',
            max_age_days=1.5, percentile_85_age_days=1.5,
            percentile_99_age_days=1.5, sum_open_now=0,
            max_age_days_need_info=0.375, sum_need_info=0,
            percentile_85_age_days_need_info=0.375,
            percentile_99_age_days_need_info=0.375,
            percentile_low1_age_days_need_info=0.375,
            percentile_low2_age_days_need_info=0.375,
            percentile_low3_age_days_need_info=0.375,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-23', workflow='feedback',
            max_age_days=0.25, percentile_85_age_days=0.25,
            percentile_99_age_days=0.25, sum_open_now=1,
            max_age_days_need_info=0.0, sum_need_info=0,
            percentile_85_age_days_need_info=0.0,
            percentile_99_age_days_need_info=0.0,
            percentile_low1_age_days_need_info=0.0,
            percentile_low2_age_days_need_info=0.0,
            percentile_low3_age_days_need_info=0.0,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=0,
        ),
    ])


def test_none_start_time():
    cluster = clusters.MockCluster()
    job = cluster.job()
    job = eval_report.make_testable_job(job, '2020-03-18', '2020-03-19')

    record_dict = {
        'created_at' : '2020-03-19 12:00:00',
        'resolved_at' : None,
        'type' : 'address',
        'source' : 'fbapi',
        'workflow' : 'feedback',
        'history' : [{
            "modifiedAt" : "2020-03-19 12:00:00",
            "operation" : "create"
        }, {
            "modifiedAt" : "2020-03-19 12:00:00",
            "operation" : "reveal"
        }, {
            "modifiedAt" : "2020-03-19 18:00:00",
            "operation" : "need-info"
        }]
    }

    feedback = [Record.from_dict(record_dict)]
    relevant = []
    daily_result = []

    job.local_run(
        sources={'feedback_db': local.StreamSource(feedback)},
        sinks={
            'relevant': local.ListSink(relevant),
            'daily_result': local.ListSink(daily_result)
        }
    )

    assert sorted(daily_result) == sorted([
        Record(
            fielddate='2020-03-19', workflow='feedback',
            max_age_days=0.25, percentile_85_age_days=0.25,
            percentile_99_age_days=0.25, sum_open_now=0,
            max_age_days_need_info=0.25, sum_need_info=1,
            percentile_85_age_days_need_info=0.25,
            percentile_99_age_days_need_info=0.25,
            percentile_low1_age_days_need_info=0.25,
            percentile_low2_age_days_need_info=0.25,
            percentile_low3_age_days_need_info=0.25,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=1,
        )
    ])


def test_need_info_accepted():
    cluster = clusters.MockCluster()
    job = cluster.job()
    job = eval_report.make_testable_job(job, '2020-03-18', '2020-03-20')

    record_dict = {
        'created_at' : '2020-03-19 12:00:00',
        'resolved_at' : None,
        'type' : 'address',
        'source' : 'fbapi',
        'workflow' : 'feedback',
        'history' : [{
            "modifiedAt" : "2020-03-19 12:00:00",
            "operation" : "create"
        }, {
            "modifiedAt" : "2020-03-19 12:00:00",
            "operation" : "reveal"
        }, {
            "modifiedAt" : "2020-03-19 18:00:00",
            "operation" : "need-info"
        }, {
            "modifiedAt" : "2020-03-19 21:00:00",
            "operation" : "accept"
        }, {
            "modifiedAt" : "2020-03-20 06:00:00",
            "operation" : "need-info"
        }, {
            "modifiedAt" : "2020-03-20 12:00:00",
            "operation" : "reject"
        }]
    }

    feedback = [Record.from_dict(record_dict)]
    relevant = []
    daily_result = []

    job.local_run(
        sources={'feedback_db': local.StreamSource(feedback)},
        sinks={
            'relevant': local.ListSink(relevant),
            'daily_result': local.ListSink(daily_result)
        }
    )

    assert sorted(daily_result) == sorted([
        Record(
            fielddate='2020-03-19', workflow='feedback',
            max_age_days=0.25, percentile_85_age_days=0.25,
            percentile_99_age_days=0.25, sum_open_now=0,
            max_age_days_need_info=0.125, sum_need_info=0,
            percentile_85_age_days_need_info=0.125,
            percentile_99_age_days_need_info=0.125,
            percentile_low1_age_days_need_info=0.125,
            percentile_low2_age_days_need_info=0.125,
            percentile_low3_age_days_need_info=0.125,
            resolved_in_1day_need_info=1,
            resolved_in_30days_need_info=1,
            resolved_in_3days_need_info=1,
            resolved_in_7days_need_info=1,
            total_count_need_info=1,
        ),
        Record(
            fielddate='2020-03-20', workflow='feedback',
            max_age_days=0.0, percentile_85_age_days=0.0,
            percentile_99_age_days=0.0, sum_open_now=0,
            max_age_days_need_info=0.25, sum_need_info=0,
            percentile_85_age_days_need_info=0.25,
            percentile_99_age_days_need_info=0.25,
            percentile_low1_age_days_need_info=0.25,
            percentile_low2_age_days_need_info=0.25,
            percentile_low3_age_days_need_info=0.25,
            resolved_in_1day_need_info=1,
            resolved_in_30days_need_info=1,
            resolved_in_3days_need_info=1,
            resolved_in_7days_need_info=1,
            total_count_need_info=1,
        )
    ])
