import maps.wikimap.stat.feedback_age_to_yt.lib.eval_report as eval_report
import maps.wikimap.stat.feedback_age_to_yt.lib.eval_report_closure as eval_report_closure

from nile.api.v1 import (
    cli
)

import datetime


def make_nirvana_job(job, nirvana, options):
    yesterday_iso_str = (datetime.date.today() - datetime.timedelta(days=1)).isoformat()

    if options.report_type == 'feedback':
        return eval_report.make_job(job, yesterday_iso_str, yesterday_iso_str, options.report)
    elif options.report_type == 'closures':
        return eval_report_closure.make_job(job, yesterday_iso_str, yesterday_iso_str, options.report)
    else:
        raise RuntimeError("Wrong report type")


def main():
    cli.statinfra_job(
        options=[
            cli.Option('report', required=True),
            cli.Option('report-type', required=True)
        ]
    )(make_nirvana_job)
    cli.run()


if __name__ == "__main__":
    main()
