from __future__ import print_function

import maps.wikimap.stat.feedback_age_to_yt.lib.eval_report as eval_report

from common import days_ago_str, create_feedback_record

from nile.api.v1 import (
    local,
    clusters,
    Record
)


def test_eval_report():
    print('Testing')

    cluster = clusters.MockCluster()
    job = cluster.job()
    job = eval_report.make_testable_job(job, days_ago_str(1), days_ago_str(1))

    feedback = [
        # pX: Y1 + (Y2 - Y1) * ((X - X1) / (X2 - X1))
        # p0.85: 0.25 + (0.5 - 0.25) * ((0.85 - 0.5) / (1.0 - 0.5)) = 0.425
        create_feedback_record('12:00:00', 'task', 'mrc', 'maneuver'),
        create_feedback_record('18:00:00', 'task', 'gps', 'road-direction'),
        create_feedback_record('21:00:00', 'task', 'sprav', 'address'),

        # p0.85: 10 + (20 - 10) * 0.85 = 18.5
        create_feedback_record(days_ago_str(10) + ' 00:00:00', 'feed', 'fbapi', 'address'),
        create_feedback_record(days_ago_str(20) + ' 00:00:00', 'feed', 'sprav-georef', 'barrier'),

        # Must be filtered out:
        create_feedback_record(days_ago_str(100) + ' 00:00:00', 'task', 'mrc', 'wrong-parking'),
        create_feedback_record(days_ago_str(100) + ' 00:00:00', 'task', 'mrc', 'wrong-speed-limit'),
        create_feedback_record(days_ago_str(100) + ' 00:00:00', 'task', 'mrc', 'traffic-lane-sign'),
        create_feedback_record(days_ago_str(100) + ' 00:00:00', 'feed', 'fbapi', 'road-closure'),
        create_feedback_record(days_ago_str(100) + ' 00:00:00', 'feed', 'experiment-fbapi', 'address'),
    ]

    relevant = []
    daily_result = []

    job.local_run(
        sources={'feedback_db': local.StreamSource(feedback)},
        sinks={
            'relevant': local.ListSink(relevant),
            'daily_result': local.ListSink(daily_result)
        }
    )

    assert sorted(daily_result) == sorted([
        Record(
            fielddate=days_ago_str(1), workflow='feedback',
            max_age_days=20.0, percentile_85_age_days=18.5,
            percentile_99_age_days=19.9, sum_open_now=2,
            max_age_days_need_info=0.0, sum_need_info=0,
            percentile_85_age_days_need_info=0.0,
            percentile_99_age_days_need_info=0.0,
            percentile_low1_age_days_need_info=0.0,
            percentile_low2_age_days_need_info=0.0,
            percentile_low3_age_days_need_info=0.0,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=0,
        ),
        Record(
            fielddate=days_ago_str(1), workflow='task',
            max_age_days=0.5, percentile_85_age_days=0.425,
            percentile_99_age_days=0.495, sum_open_now=3,
            max_age_days_need_info=0.0, sum_need_info=0,
            percentile_85_age_days_need_info=0.0,
            percentile_99_age_days_need_info=0.0,
            percentile_low1_age_days_need_info=0.0,
            percentile_low2_age_days_need_info=0.0,
            percentile_low3_age_days_need_info=0.0,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=0,
        ),
        Record(
            fielddate=days_ago_str(1), workflow='task-minor',
            max_age_days=100.0, percentile_85_age_days=100.0,
            percentile_99_age_days=100.0, sum_open_now=3,
            max_age_days_need_info=0.0, sum_need_info=0,
            percentile_85_age_days_need_info=0.0,
            percentile_99_age_days_need_info=0.0,
            percentile_low1_age_days_need_info=0.0,
            percentile_low2_age_days_need_info=0.0,
            percentile_low3_age_days_need_info=0.0,
            resolved_in_1day_need_info=0,
            resolved_in_30days_need_info=0,
            resolved_in_3days_need_info=0,
            resolved_in_7days_need_info=0,
            total_count_need_info=0,
        ),
    ])
