import maps.wikimap.stat.kpi.absolute_objects_counts_stat.lib.job_options as jo
import maps.wikimap.stat.kpi.absolute_objects_counts_stat.lib.eval_report as eval_report
import maps.wikimap.stat.libs.common.lib.cli_options as cli_opts

from nile.api.v1 import cli


@cli.statinfra_job(options=jo.JOB_OPTIONS)
def make_job(job, options, statface_client):
    fielddate = jo.extract_fielddate(options)
    report_descriptor = jo.get_report_descriptor(options.report_type)
    return eval_report.make_job(
        job,
        options.scale,
        statface_client,
        fielddate,
        report_descriptor,
        options.ymapsdf_path or jo.DEFAULT_YMAPSDF_PATH,
        [''] if options.no_regions else jo.DEFAULT_REGIONS,
        jo.extract_tables(options, report_descriptor.available_tables),
        cli_opts.get_results_path(options),
    )


def main():
    cli.run()
