#!/bin/sh -eux

export YT_PROXY="hahn"
path_to_data="//home/maps/core/garden/stable/ymapsdf_archive"
binary="`dirname "${0}"`/absolute_objects_counts_stat"

for directory in `ya tool yt list "${path_to_data}"`; do
    # directory name is equal to ymapsdf shipping_date
    # first token of shipping_date is date in format YYYYmmdd
    ymapsdfdate=`echo "${directory}" | awk -F_ '{print $1}'`

    # extract year and month from shipping_date:
    # stat needs first date of period to store report
    # month scale is used here, so use first day of month
    recalc_month=`date --date="${ymapsdfdate}" "+%Y-%m"`

    for report_type in "length" "count"; do
        ${binary} run \
            --report-type ${report_type} \
            --ymapsdf-path "${path_to_data}/${directory}" \
            --no-regions \
            --proxy "${YT_PROXY}" \
            --scale monthly \
            --dates "${recalc_month}-01"
    done
done
