# Map from https://a.yandex-team.ru/arc/trunk/arcadia/maps/doc/schemas/ymapsdf/garden/create/ft_type.sql?rev=6082660#L38
FT_MAP = {
    # Vegetation
    401: 'vegetation',                              # 'растительность'
    402: 'vegetation-park',                         # 'парк'
    403: 'vegetation-natpark',                      # 'заповедник, национальный парк'
    404: 'vegetation-lawn',                         # 'газон'
    405: 'vegetation-garden',                       # 'сад'
    406: 'vegetation-residential',                  # 'внутриквартальная растительность'
    221: 'urban-cemetery',                          # 'кладбище'

    # Hydrography
    501: 'hydro-ocean',                             # 'океан'
    502: 'hydro-sea',                               # 'море'
    503: 'hydro-bay',                               # 'залив, гавань'
    504: 'hydro-strait',                            # 'пролив'
    505: 'hydro-lake',                              # 'озеро, водоём'
    506: 'hydro-reservoir',                         # 'водохранилище'
    507: 'hydro-pond',                              # 'пруд'
    508: 'hydro-swamp',                             # 'болото'
    509: 'hydro-glacier',                           # 'ледник'
    517: 'hydro-group-of-lakes',                    # 'группа озёр'

    510: 'hydro-pool',                              # 'чаша открытого бассейна, аквапарка'
    511: 'hydro-spring',                            # 'ключ'
    512: 'hydro-fountain',                          # 'фонтан'
    513: 'hydro-waterfall',                         # 'водопад'
    514: 'hydro-well',                              # 'колодец'
    515: 'hydro-sluice',                            # 'шлюз'
    516: 'hydro-geyser',                            # 'гейзер'
    518: 'hydro-standpipe',                         # 'водоразборная колонка'

    552: 'hydro-river-large',                       # 'крупная река'
    553: 'hydro-river',                             # 'средняя река'
    554: 'hydro-river-small',                       # 'малая река'
    555: 'hydro-river-stream',                      # 'ручей'
    556: 'hydro-river-irrigation',                  # 'ирригационный канал'
    557: 'hydro-river-intermittent',                # 'пересыхающая река'
    558: 'hydro-river-greatest',                    # 'крупнейшая река'
    559: 'hydro-river-canal',                       # 'канал'

    # Relief
    301: 'relief',                                  # 'элемент рельефа и ландшафта'
    302: 'relief-island',                           # 'остров'
    305: 'relief-archipelago',                      # 'архипелаг'
    306: 'relief-mountain',                         # 'вершина'
    307: 'relief-pass',                             # 'перевал'
    308: 'relief-volcano',                          # 'вулкан'

    # Buildings and Built Environment Areas
    101: 'urban-residential',                       # 'жилой'
    102: 'urban-industrial',                        # 'промышленный'
    104: 'urban-public',                            # 'общественный'
    106: 'urban-structure',                         # 'сооружение, некапитальная постройка'
    261: 'urban-transport',                         # 'транспортное сооружение'

    107: 'urban-complex',                           # 'комплекс зданий'

    151: 'urban-under-construction',                # 'стройплощадка, строящийся объект'
    201: 'urban-sport-golf',                        # 'поле для гольфа'

    # Squares and Roadnet Structures
    240: 'urban-roadnet-roadconstruction',          # 'дорожное сооружение'
    241: 'urban-roadnet-square',                    # 'площадь (не участвующая в дорожном движении'
    242: 'urban-roadnet-bridge',                    # 'мост (не участвующий в дорожном движении'
    243: 'urban-roadnet-tunnel',                    # 'туннель (не участвующий в дорожном движении'
    250: 'urban-roadnet-traffic-light',             # 'светофор'
    252: 'urban-roadnet-pedestrian-overpass',       # 'надземный пешеходный переход'
    255: 'urban-roadnet-pedestrian-bridge',         # 'пешеходный мост'
    256: 'urban-roadnet-pedestrian-underpass',      # 'подземный переход'
    257: 'urban-roadnet-fence',                     # 'забор'
    258: 'urban-roadnet-gate-car',                  # 'шлагбаум, ворота'
    259: 'urban-roadnet-gate-pedestrian',           # 'калитка'
    260: 'urban-roadnet-block',                     # 'блок, запрет проезда'
    251: 'urban-roadnet-parking-lot',               # 'парковка'
    2001: 'urban-roadnet-parking-free',             # 'бесплатная парковка'
    2002: 'urban-roadnet-parking-toll',             # 'платная парковка'
    2003: 'urban-roadnet-parking-restricted',       # 'парковка ограниченного пользования'
    2004: 'urban-roadnet-parking-prohibited',       # 'парковка запрещена'
    2005: 'urban-roadnet-parking-meter',            # 'паркомат'
    2006: 'urban-roadnet-parking-parkandride',      # 'перехватывающая'
    2007: 'urban-roadnet-parking-free-bld',         # 'бесплатная парковка в здании'
    2008: 'urban-roadnet-parking-toll-bld',         # 'платная парковка в здании'
    2009: 'urban-roadnet-parking-restricted-bld',   # 'парковка ограниченного пользования в здании'
    2010: 'urban-roadnet-parking-controlled-zone',  # 'зона платной пaрковки'

    2111: 'urban-roadnet-arrival-point',            # 'точка прибытия'
    2112: 'urban-roadnet-arrival-point-dropoff-pickup',  # 'зона высадки и посадки'

    2021: 'urban-roadnet-closure',                  # 'перекрытие движения'

    # Public city Transport: road, rail, water,#  metro
    631: 'transport-system',                        # 'транспортная система'

    2201: 'transport-bus-route',                    # 'маршрут автобуса'
    2202: 'transport-trolleybus-route',             # 'маршрут троллейбуса'
    2203: 'transport-tram-route',                   # 'маршрут трамвая'
    2204: 'transport-minibus-route',                # 'маршрут маршрутного такси'
    625: 'transport-metro-light-line',              # 'линия легкого метро'
    626: 'transport-metro-tram-line',               # 'линия скоростного трамвая'
    627: 'transport-metro-monorail-line',           # 'линия монорельса'
    628: 'transport-metro-bus-line',                # 'линия скоростного автобуса'
    629: 'transport-metro-cable-line',              # 'линия городской канатной дороги'
    630: 'transport-metro-funicular-line',          # 'линия городского фуникулера'
    632: 'transport-metro-line',                    # 'линия метро'
    2208: 'transport-waterway-route',               # 'маршрут водного транспорта'

    2205: 'transport-bus-thread',                   # 'нитка маршрута городского наземного транспорта'
    2212: 'transport-tram-thread',                  # 'нитка маршрута трамвая'
    2213: 'transport-waterway_thread',              # 'нитка маршрута городского водного транспорта'
    2214: 'transport-metro_thread',                 # 'нитка маршрута скоростного транспорта'

    2206: 'transport-thread-stop',                  # 'остановка в составе нитки маршрута'

    671: 'transport-bus-stop',                      # 'остановка общественного транспорта'
    633: 'transport-metro-station',                 # 'станция скоростного городского транспорта'
    634: 'transport-metro-exit',                    # 'выход со станции скоростного транспорта'
    602: 'transport-waterway-wharf',                # 'пристань'
    603: 'transport-waterway-seaport',              # 'морской порт, вокзал'
    604: 'transport-waterway-riverport',            # 'речной порт, вокзал'

    2209: 'transport-metro-transition',             # 'переход между станциями скоростного транспорта'
    2210: 'transport-metro-passageway',             # 'проход от станции скоростного транспорта к выходу'

    2207: 'transport_freq_dt',                      # 'расписание движения общественного транспорта'

    2211: 'trnasport_route_alias',                  # 'синоним для маршрута общественного транспорта'

    661: 'transport-tram',                          # 'трамвайные пути'
    601: 'transport-waterway',                      # 'водный путь'

    # Transport
    681: 'transport-bus-terminal',                  # 'автовокзал, автостанция'
    686: 'transport-taxi-stop',                     # 'стоянка такси'
    691: 'transport-depot',                         # 'депо'


    # Railway Transport
    611: 'transport-railway',                       # 'железная дорога'
    612: 'transport-railway-siding',                # 'подъездные пути'
    613: 'transport-railway-children',              # 'детская железная дорога'
    614: 'transport-railway-narrow-gauge',          # 'узкоколейная железная дорога'
    617: 'transport-railway-terminal',              # 'железнодорожный вокзал'
    618: 'transport-railway-station',               # 'станция'
    619: 'transport-railway-goods-station',         # 'непассажирская станция'
    620: 'transport-railway-ferry',                 # 'железнодорожная паромная переправа'
    621: 'transport-railway-exit',                  # 'выход из железнодорожного вокзала или станции'
    622: 'transport-railway-platform',              # 'железнодорожная платформа'

    # Avia Transport
    641: 'transport-airport',                       # 'аэропорт, международный аэропорт'
    642: 'transport-airport-domestic',              # 'местный аэропорт'
    645: 'transport-airport-airfield',              # 'аэродром'
    651: 'transport-helicopter',                    # 'вертолетная площадка'
    643: 'transport-airport-terminal',              # 'терминал аэропорта'
    644: 'transport-airport-road',                  # 'взлетно-посадочная полоса и рулежные дорожки'

    # Medical Buildings, Organizations, and Areas
    1000: 'urban-med',                               # 'медицинское учреждение'
    172: 'urban-med-hospital',                       # 'больница, поликлиника'
    1001: 'urban-med-dental',                        # 'стоматология'
    1002: 'urban-med-veterinary',                    # 'ветеринария'
    181: 'urban-med-pharmacy',                       # 'аптека'
    1004: 'urban-med-optician',                      # 'оптика'
    1005: 'urban-med-first-aid-post',                # 'медицинский пункт'

    # Educational Buildings, Organizations, and Areas
    171: 'urban-edu',                                # 'образовательное учреждение'
    167: 'urban-edu-kindergarten',                   # 'детский сад'
    168: 'urban-edu-school-secondary',               # 'общеобразовательная и начальная школа, гимназия'
    166: 'urban-edu-vocational',                     # 'колледж, техникум'
    169: 'urban-edu-university',                     # 'ВУЗ, консерватория'
    165: 'urban-edu-extra-academic',                 # 'дополнительное образование'
    182: 'urban-edu-library',                        # 'библиотека'
    164: 'urban-edu-scientific',                     # 'научное учреждение'

    # Government and Public Service Organizations
    103: 'urban-gov',                                # 'муниципальное, государственное учреждение'
    1101: 'urban-gov-government',                    # 'администрация, правительство'
    1102: 'urban-gov-court',                         # 'суд, прокуратура'
    1103: 'urban-gov-police',                        # 'полиция, милиция'
    1104: 'urban-gov-firefighting',                  # 'МЧС, пожарная часть'
    1105: 'urban-gov-civil-registry',                # 'ЗАГС'
    1106: 'urban-gov-migration',                     # 'УФМС, паспортный стол'
    1107: 'urban-gov-center',                        # 'МФЦ, ЕЦД, ЕИРЦ'
    1108: 'urban-gov-social-security',               # 'пенсионный фонд, управление соц. защиты'
    183: 'urban-gov-tax-inspectorate',               # 'налоговая инспекция'
    184: 'urban-gov-recruitment-center',             # 'военкомат и комиссариат'
    1109: 'urban-gov-prison',                        # 'исправительное заведение'
    1110: 'urban-gov-condo-management',              # 'ТСЖ, управляющая компания'
    1111: 'urban-gov-post',                          # 'почта, отделение связи'
    1112: 'urban-gov-embassy',                       # 'посольство, консульство, визовый центр'
    1113: 'urban-gov-station-administration',        # 'администрация вокзала'
    1114: 'urban-gov-station-attendant',             # 'дежурный по вокзалу'
    1115: 'urban-gov-commandature',                  # 'военный комендант'
    1116: 'urban-gov-control',                       # 'таможенный и миграционный контроль'

    # Religios Buildings, Organizations, and Areas
    114: 'urban-religion-worship',                   # 'культовое сооружение'
    110: 'urban-religion-christ',                    # 'церковь, собор'
    111: 'urban-religion-islam',                     # 'мечеть'
    112: 'urban-religion-judaism',                   # 'синагога'
    113: 'urban-religion-buddhism',                  # 'пагода'

    # Foodservice Organizations
    176: 'urban-foodservice',                        # 'общественное питание'
    177: 'urban-foodservice-fastfood',               # 'столовая, фастфуд'
    178: 'urban-foodservice-bar',                    # 'бар, пивная'
    180: 'urban-foodservice-restaurant',             # 'кафе, ресторан'
    179: 'urban-foodservice-coffee-shop',            # 'кофейня, кондитерская'

    # Shopping Buildings, Organizations, and Areas
    173: 'urban-shopping',                           # 'магазин'
    1301: 'urban-shopping-mall',                     # 'торговый центр, молл'
    1302: 'urban-shopping-stall',                    # 'ларек, киоск'
    1303: 'urban-shopping-market-farmers',           # 'продуктовый рынок'
    1304: 'urban-shopping-market-clothes',           # 'вещевой рынок'
    1305: 'urban-shopping-market-household',         # 'строительно-хозяйственный рынок'
    175: 'urban-shopping-grocery',                   # 'супермаркет, продуктовый магазин'
    1306: 'urban-shopping-flowers',                  # 'магазин цветов'
    1307: 'urban-shopping-book',                     # 'книжный, канцтовары'
    1308: 'urban-shopping-antiques',                 # 'антиквариат, искусство'
    1309: 'urban-shopping-household',                # 'хозтовары, инструменты, стройматериалы'
    1310: 'urban-shopping-appliances',               # 'магазин техники'
    1311: 'urban-shopping-sport',                    # 'спорт, туризм'
    1312: 'urban-shopping-perfumery',                # 'магазин косметики, парфюмерия'
    1313: 'urban-shopping-furniture',                # 'мебель, интерьер'
    1314: 'urban-shopping-fashion',                  # 'магазин одежды и обуви'
    1315: 'urban-shopping-textile',                  # 'магазин ткани, рукоделие'
    1316: 'urban-shopping-pet',                      # 'зоомагазин'
    1317: 'urban-shopping-toy',                      # 'игрушки, детский магазин'
    1318: 'urban-shopping-jewelry',                  # 'ювелирный магазин'
    1319: 'urban-shopping-souvenirs',                # 'подарки, сувениры'
    1320: 'urban-shopping-delivery',                 # 'пункт выдачи'

    # Vehicle Services, Places and Organizations
    1400: 'urban-car',                               # 'авто'
    253: 'urban-car-fuel-station',                   # 'заправочная станция'
    254: 'urban-car-traffic-police',                 # 'пост ДПС, ГИББД'
    1401: 'urban-car-dealership',                    # 'автосалон, авторынок'
    1402: 'urban-car-parts',                         # 'автозапчасти'
    1403: 'urban-car-repairshop',                    # 'автосервис'
    1404: 'urban-car-tyreshop',                      # 'шиномонтаж'
    1405: 'urban-car-carwash',                       # 'автомойка'
    1406: 'urban-car-garage',                        # 'гаражный кооператив'
    1407: 'urban-car-driving-school',                # 'автошкола'
    1408: 'urban-car-impound-lot',                   # 'штрафстоянка'
    1409: 'urban-car-training-facility',             # 'тренировочная, экзаменационная площадка'
    1410: 'urban-car-inspection-station',            # 'пункт технического осмотра'

    # Financial Places and Organizations
    1500: 'urban-money',                             # 'финансовая организация'
    1501: 'urban-money-bank',                        # 'банк'
    1502: 'urban-money-pawnshop',                    # 'ломбард'
    1503: 'urban-money-atm',                         # 'банкомат'
    1504: 'urban-money-currency-exchange',           # 'обмен валюты'
    1505: 'urban-money-payment-machine',             # 'терминал оплаты'
    1506: 'urban-money-insurance',                   # 'страховая компания'
    1507: 'urban-money-microfinance',                # 'микрофинансирование'
    1508: 'urban-money-coin-kiosk',                  # 'автомат для приема монет'
    1509: 'urban-money-taxfree',                     # 'tax free'

    # Service Organizations and Places
    1600: 'urban-service',                           # 'предприятие, организация'
    1601: 'urban-service-factory',                   # 'завод, промышленное предприятие'
    1602: 'urban-service-notary',                    # 'нотариус'
    1603: 'urban-service-lawyer',                    # 'адвокат, юридические услуги'
    1604: 'urban-service-barbershop',                # 'парикмахерская, салон красоты, солярий'
    1605: 'urban-service-laundry',                   # 'химчистка, прачечная'
    1606: 'urban-service-repair',                    # 'ремонт одежды, обуви, ателье'
    1607: 'urban-service-photo',                     # 'фотоуслуги'
    1608: 'urban-service-phoneshop',                 # 'салон сотовой связи'
    1609: 'urban-service-travel-agency',             # 'туристическое агентство'
    1610: 'urban-service-ticket-transport',          # 'транспортные кассы'
    1611: 'urban-service-sauna',                     # 'баня, сауна'
    1612: 'urban-service-funeral',                   # 'ритуальные услуги'
    1613: 'urban-service-realty',                    # 'агентство недвижимости'
    1614: 'urban-service-waste-disposal',            # 'полигон ТБО'
    1615: 'urban-service-toilet',                    # 'туалет'
    1616: 'urban-service-nonprofit',                 # 'некоммерческая организация, фонд'
    1617: 'urban-service-nursing-room',              # 'комната матери и ребенка'
    1618: 'urban-service-toilet-disabled',           # 'туалет для инвалидов'
    105: 'urban-business-center',                    # 'бизнес-центр'

    # Sport Buildings, Organizations, and Areas
    191: 'urban-sport',                              # 'спортивный объект'
    1701: 'urban-sport-stadium',                     # 'стадион, спорткомплекс'
    1702: 'urban-sport-club',                        # 'спортклуб, тренажерный зал, фитнес'
    1703: 'urban-sport-swimming-pool',               # 'плавательный бассейн'
    1704: 'urban-sport-ski',                         # 'лыжная база, горнолыжный комплекс'
    1705: 'urban-sport-hippodrome',                  # 'конно-спортивный клуб, ипподром'
    1706: 'urban-sport-racetrack',                   # 'авто-, мото-, велодром, картинг'
    1707: 'urban-sport-skatingrink',                 # 'каток'

    # Leisure Places and Organizations
    222: 'urban-leisure',                            # 'досуг, отдых, культура'
    185: 'urban-leisure-hotel',                      # 'гостиница, хостел'
    226: 'urban-leisure-beach',                      # 'пляж'
    1801: 'urban-leisure-sanatorium',                # 'санаторий, дом отдыха'
    1802: 'urban-leisure-kidscamp',                  # 'детский лагерь'
    223: 'urban-leisure-animalpark',                 # 'зоопарк, дельфинарий'
    227: 'urban-leisure-theater',                    # 'театр'
    230: 'urban-leisure-concert-hall',               # 'концертный зал, филармония'
    228: 'urban-leisure-circus',                     # 'цирк'
    229: 'urban-leisure-cinema',                     # 'кинотеатр'
    232: 'urban-leisure-museum',                     # 'музей'
    224: 'urban-leisure-amusementpark',              # 'парк развлечений, аттракционы'
    1803: 'urban-leisure-entertainment-center',      # 'бильярд, боулинг, развлекательный центр'
    1804: 'urban-leisure-waterpark',                 # 'аквапарк'
    1805: 'urban-leisure-house-of-culture',          # 'дом культуры'
    1806: 'urban-leisure-night-club',                # 'дискотека, ночной клуб'
    1807: 'urban-leisure-observation-deck',          # 'обзорная площадка'
    1808: 'urban-leisure-monument',                  # 'памятник, скульптура'
    1: 'landmark',                                   # 'достопримечательность'

    # Residential Infrastructure
    225: 'urban-playground',                         # 'игровая площадка'
    202: 'urban-sportground',                        # 'спортплощадка, спортивное поле, арена стадиона'
    233: 'urban-dogrun',                             # 'собачья площадка'
    220: 'urban-garbage',                            # 'мусорная площадка'
    1901: 'urban-bike-rental',                       # 'прокат велосипедов'
    1903: 'urban-bike-parking-lot',                  # 'велопарковка'
    1902: 'urban-landmark-minor',                    # 'интересное место'
    1904: 'urban-entrance',                          # 'подъезд'

    # Disputed Boundaries
    701: 'disputed-boundary',                        # 'спорная граница страны'

    # Yellow Zones
    801: 'urban-yellow-zone',                        # 'желтая зона'

    # Postal/Zip code
    2100: 'zipcode',                                 # 'почтовый код территории'

    # Indoor Infrastructure: plans/levels, polygonal objects, linear objects, point objects
    2301: 'indoor-plan',                             # 'план схемы помещений'
    2302: 'indoor-level',                            # 'уровень схемы помещений'
    2303: 'indoor-level-underground',                # 'подземный уровень схемы помещений'
    2304: 'indoor-barrier',                          # 'стена, перегородка'

    2401: 'indoor-area-public',                      # 'публичная зона'
    2402: 'indoor-area-business',                    # 'торговая зона'
    2403: 'indoor-area-service',                     # 'зона служебного пользования'
    2404: 'indoor-area-void',                        # 'зона второго света'
    2405: 'indoor-area-parking',                     # 'зона парковки'
    2406: 'indoor-area-restricted',                  # 'зона с ограниченым доступом'

    2501: 'indoor-infra-elevator',                   # 'лифт'
    2502: 'indoor-infra-escalator',                  # 'эскалатор'
    2503: 'indoor-infra-travolator',                 # 'траволатор'
    2504: 'indoor-infra-stairs',                     # 'лестница'
    2505: 'indoor-infra-emergency-exit',             # 'эвакуационный выход'
    2506: 'indoor-infra-fire-stairs',                # 'пожарная лестница'
    2507: 'indoor-infra-control-frame',              # 'металлодетектор'
    2508: 'indoor-infra-luggage-inspection',         # 'досмотр и проверка багажа'
    2509: 'indoor-infra-pandus',                     # 'пандус'
    2510: 'indoor-infra-gate',                       # 'выход на посадку'
    2511: 'indoor-infra-elevator-disabled',          # 'лифт для инвалидов'

    2601: 'indoor-info-arrival',                     # 'табло прибытия'
    2602: 'indoor-info-departure',                   # 'табло отправления'
    2603: 'indoor-info-stand',                       # 'информационная стойка'
    2604: 'indoor-info-scheme',                      # 'схема вокзала/аэропорта'
    2605: 'indoor-info-inquiry-office',              # 'справочная'
    2606: 'indoor-info-meetingpoint',                # 'место встречи'
    2607: 'indoor-info-schedule',                    # 'табло вылета-прилета-прибытия-отправления'

    2701: 'indoor-service-wardrobe',                 # 'гардероб'
    2702: 'indoor-service-fitting-room',             # 'примерочная'
    2703: 'indoor-service-luggage-storage',          # 'камера хранения'
    2704: 'indoor-service-ticket-office',            # 'билетная касса'
    2705: 'indoor-service-smoking-room',             # 'комната для курения'
    2706: 'indoor-service-wheelchair-rent',          # 'кресло-каталка напрокат'
    2707: 'indoor-service-charging-socket',          # 'розетка для зарядки'
    2708: 'indoor-service-instant-photo',            # 'мгновенное фото'
    2709: 'indoor-service-waiting-room',             # 'зал ожидания'
    2710: 'indoor-service-shopping-cart-parking',    # 'парковка тележек'
    2711: 'indoor-service-vending-machine',          # 'вендинговый автомат'
    2712: 'indoor-service-luggage',                  # 'багажные сервисы'
    2713: 'indoor-service-checkin-desk',             # 'стойка регистрации'
    2714: 'indoor-service-luggage-claim',            # 'выдача багажа'
    2715: 'indoor-service-luggage-oversized-dropoff',   # 'прием негабаритного багажа'
    2716: 'indoor-service-luggage-oversized-claim',  # 'выдача негабаритного багажа'
    2717: 'indoor-service-shower',                   # 'душ'

    2801: 'indoor-leisure-cinema-hall',              # 'зал кинотеатра'
    2802: 'indoor-leisure-slot-machine',             # 'игровой автомат'
    2803: 'indoor-leisure-scene',                    # 'сцена/развлекательная площадка'
    2804: 'indoor-leisure-aquarium',                 # 'аквариум'
    2805: 'indoor-leisure-massage-chair',            # 'массажное кресло'

    # Obsolete
    2: 'landmark-milestone',                         # 'obsolete: километр автомагистрали'
    551: 'hydro-river-composite',                    # 'obsolete: составная река'
    303: 'relief-rock',                              # 'obsolete: скала'
    304: 'relief-sand',                              # 'obsolete: пески'
    152: 'urban-demolished',                         # 'obsolete: снесенный объект'
    174: 'urban-shopping-supermarket',               # 'obsolete: супермаркет'
    186: 'urban-business-center-obsolete',           # 'obsolete: бизнес-центр'
    231: 'urban-leisure-philarmonic',                # 'obsolete: филармония'
    615: 'transport-railway-cable',                  # 'obsolete: линия канатной дороги'
    616: 'transport-railway-funicular',              # 'obsolete: линия фуникулера'
    636: 'transport-rapid-line',                     # 'obsolete: линия скоростного транспорта'
    637: 'transport-rapid-station',                  # 'obsolete: станция скоростного транспорта'
    638: 'transport-rapid-exit',                     # 'obsolete: выход со станции скоростного транспорта'
    662: 'transport-tram-stop',                      # 'obsolete: остановка трамвая'
    665: 'transport-share-taxi-stop',                # 'obsolete: остановка маршрутного такси'

    # 90000-99999 Reserved
}


# List from https://a.yandex-team.ru/arc/trunk/arcadia/maps/garden/modules/renderer_denormalization/tool/lib/base/ymapsdf.h?rev=6348913#L313
POIS = set([
    'hydro-pool',
    'hydro-fountain',
    'urban-med',
    'urban-med-hospital',
    'urban-med-dental',
    'urban-med-veterinary',
    'urban-med-pharmacy',
    'urban-med-optician',
    'urban-edu',
    'urban-edu-kindergarten',
    'urban-edu-school-secondary',
    'urban-edu-vocational',
    'urban-edu-university',
    'urban-edu-extra-academic',
    'urban-edu-library',
    'urban-edu-scientific',
    'urban-gov',
    'urban-gov-government',
    'urban-gov-court',
    'urban-gov-police',
    'urban-gov-firefighting',
    'urban-gov-civil-registry',
    'urban-gov-migration',
    'urban-gov-center',
    'urban-gov-social-security',
    'urban-gov-tax-inspectorate',
    'urban-gov-recruitment-center',
    'urban-gov-prison',
    'urban-gov-condo-management',
    'urban-gov-post',
    'urban-gov-embassy',
    'urban-religion-worship',
    'urban-religion-christ',
    'urban-religion-islam',
    'urban-religion-judaism',
    'urban-religion-buddhism',
    'urban-foodservice',
    'urban-foodservice-fastfood',
    'urban-foodservice-bar',
    'urban-foodservice-restaurant',
    'urban-foodservice-coffee-shop',
    'urban-shopping',
    'urban-shopping-mall',
    'urban-shopping-stall',
    'urban-shopping-market-farmers',
    'urban-shopping-market-clothes',
    'urban-shopping-market-household',
    'urban-shopping-grocery',
    'urban-shopping-flowers',
    'urban-shopping-antiques',
    'urban-shopping-book',
    'urban-shopping-household',
    'urban-shopping-appliances',
    'urban-shopping-sport',
    'urban-shopping-perfumery',
    'urban-shopping-furniture',
    'urban-shopping-fashion',
    'urban-shopping-textile',
    'urban-shopping-pet',
    'urban-shopping-toy',
    'urban-shopping-jewelry',
    'urban-shopping-souvenirs',
    'urban-shopping-delivery',
    'urban-car',
    'urban-car-fuel-station',
    'urban-car-traffic-police',
    'urban-car-dealership',
    'urban-car-parts',
    'urban-car-repairshop',
    'urban-car-tyreshop',
    'urban-car-carwash',
    'urban-car-garage',
    'urban-car-driving-school',
    'urban-car-impound-lot',
    'urban-car-training-facility',
    'urban-car-inspection-station',
    'urban-money',
    'urban-money-bank',
    'urban-money-pawnshop',
    'urban-money-atm',
    'urban-money-currency-exchange',
    'urban-money-payment-machine',
    'urban-money-insurance',
    'urban-money-microfinance',
    'urban-service',
    'urban-service-factory',
    'urban-service-notary',
    'urban-service-lawyer',
    'urban-service-barbershop',
    'urban-service-laundry',
    'urban-service-repair',
    'urban-service-photo',
    'urban-service-phoneshop',
    'urban-service-travel-agency',
    'urban-service-ticket-transport',
    'urban-service-sauna',
    'urban-service-funeral',
    'urban-service-realty',
    'urban-service-waste-disposal',
    'urban-service-toilet',
    'urban-service-nonprofit',
    'urban-business-center',
    'urban-sport',
    'urban-sport-stadium',
    'urban-sport-club',
    'urban-sport-swimming-pool',
    'urban-sport-ski',
    'urban-sport-hippodrome',
    'urban-sport-racetrack',
    'urban-leisure',
    'urban-leisure-hotel',
    'urban-leisure-beach',
    'urban-leisure-sanatorium',
    'urban-leisure-kidscamp',
    'urban-leisure-animalpark',
    'urban-leisure-circus',
    'urban-leisure-cinema',
    'urban-leisure-museum',
    'urban-leisure-amusementpark',
    'urban-leisure-theater',
    'urban-leisure-concert-hall',
    'urban-leisure-entertainment-center',
    'urban-leisure-waterpark',
    'urban-leisure-house-of-culture',
    'urban-leisure-night-club',
    'urban-leisure-observation-deck',
    'urban-leisure-monument',
    'urban-sportground',
    'urban-playground',
    'urban-dogrun',
    'urban-garbage',
    'urban-bike-rental',
    'landmark',
    'urban-landmark-minor',
    'urban-bike-parking-lot',
    'urban-cemetery',
    'vegetation',
    'vegetation-park',
    'vegetation-natpark',
])


# Sets from https://st.yandex-team.ru/NMAPS-8962 description
POI_LANDMARKS_RELIGION = set([
    'urban-religion-christ',                   # 'церковь, собор'
    'urban-religion-islam',                    # 'мечеть'
    'urban-religion-judaism',                  # 'синагога'
    'urban-religion-buddhism',                 # 'пагода'
    'urban-religion-worship',                  # 'культовое сооружение'
])

POI_LANDMARKS_CULTURE = set([
    'urban-leisure-animalpark',                # 'зоопарк, дельфинарий'
    'urban-leisure-amusementpark',             # 'парк развлечений, аттракционы'
    'urban-leisure-beach',                     # 'пляж'
    'urban-leisure-theater',                   # 'театр'
    'urban-leisure-circus',                    # 'цирк'
    'urban-leisure-concert-hall',              # 'концертный зал, филармония'
    'urban-leisure-museum',                    # 'музей'
    'urban-leisure-monument',                  # 'памятник, скульптура'
    'landmark',
])

POI_LANDMARKS_SPORT = set([
    'urban-sport-stadium',                     # 'стадион, спорткомплекс'
    'urban-sport-swimming-pool',               # 'плавательный бассейн'
    'urban-sport-ski',                         # 'лыжная база, горнолыжный комплекс'
    'urban-sport-hippodrome',                  # 'конно-спортивный клуб, ипподром'
    'urban-sport-racetrack',                   # 'авто-, мото-, велодром, картинг'
])

POI_LANDMARKS = POI_LANDMARKS_RELIGION.union(POI_LANDMARKS_CULTURE).union(POI_LANDMARKS_SPORT)


def extract_ft_name_prefixes(ft_name):
    parts = ft_name.split('-')
    return ['-'.join(parts[:i]) for i in range(1, len(parts))]


def get_all_supercategories():
    supercategories = set()
    for ft_name in FT_MAP.values():
        supercategories.update(extract_ft_name_prefixes(ft_name))
    return supercategories


SUPERCATEGORIES = get_all_supercategories()


NAMED_CATEGORIES = set([
    'urban-entrance',                          # 'подъезд'
    'urban-cemetery',                          # 'кладбище'
    'vegetation-park',                         # 'парк'
    'vegetation-natpark',                      # 'заповедник, национальный парк'

    'hydro-ocean',                             # 'океан'
    'hydro-sea',                               # 'море'
    'hydro-bay',                               # 'залив, гавань'
    'hydro-strait',                            # 'пролив'
    'hydro-lake',                              # 'озеро, водоём'
    'hydro-reservoir',                         # 'водохранилище'
    'hydro-pond',                              # 'пруд'
    'hydro-swamp',                             # 'болото'
    'hydro-glacier',                           # 'ледник'
    'hydro-group-of-lakes',                    # 'группа озёр'

    'hydro-pool',                              # 'чаша открытого бассейна, аквапарка'
    'hydro-spring',                            # 'ключ'
    'hydro-fountain',                          # 'фонтан'
    'hydro-waterfall',                         # 'водопад'
    'hydro-well',                              # 'колодец'
    'hydro-sluice',                            # 'шлюз'
    'hydro-geyser',                            # 'гейзер'
    'hydro-standpipe',                         # 'водоразборная колонка'

    'hydro-river-large',                       # 'крупная река'
    'hydro-river',                             # 'средняя река'
    'hydro-river-small',                       # 'малая река'
    'hydro-river-stream',                      # 'ручей'
    'hydro-river-irrigation',                  # 'ирригационный канал'
    'hydro-river-intermittent',                # 'пересыхающая река'
    'hydro-river-greatest',                    # 'крупнейшая река'
    'hydro-river-canal',                       # 'канал'
])

NAMED_SUPERCATEGORIES = [
    'hydro',
    'hydro-river',
]
