from maps.wikimap.stat.libs.common.lib import geobase_region

import maps.wikimap.stat.kpi.absolute_objects_counts_stat.lib.constants as c
import maps.wikimap.stat.kpi.absolute_objects_counts_stat.lib.eval_report as eval_report
import maps.wikimap.stat.kpi.absolute_objects_counts_stat.lib.job_options as jo


geobase_region.init_geodata_from_resource()


POINT_SHAPE1 = {
    'shape': '0101000020E6100000CCBD972D5F2A5440393DD62962A74540',
    'x':     80.66205921,
    'y':     43.30768321,
}
POINT_SHAPE2 = {
    'shape': '0101000020E610000007DD6A45976960403C33A06205BA4540',
    'x':     131.299715718,
    'y':     43.453289345,
}


BLD_SHAPE = (
    '0103000020E610000001000000050000008A9EA0BCCB555D40568EF1AA8CD04840A371'
    '9E6DD2555D403EB5091698D04840C1B33AC2D4555D40C869F7C795D04840A8E03C11CE'
    '555D40A168E15C8AD048408A9EA0BCCB555D40568EF1AA8CD04840'
)
#  tests case with no corresponding region in major_regions_map for the BLD_SHAPE2
BLD_SHAPE2 = (
    '0103000020E61000000100000005000000B669E876B14E60406F0FAFDCAC624540F23D'
    '8BF4AE4E60406998608C96624540E3FD97EFA94E6040E6B449739B62454037A0F471AC'
    '4E60406AE093C3B1624540B669E876B14E60406F0FAFDCAC624540'
)


# length = 68.5458511728 meters
# LINESTRING (55.9354508870000018 54.7280069839999967, 55.9351840189999976 54.7274109060000029)
RD_EL_SHAPE1 = "0102000020E610000002000000F056CBDABCF74B4011C535552F5D4B4065AC241CB4F74B400A03F2CC1B5D4B40"
# length = 146.227107637 meters
# LINESTRING (49.4013364190000033 53.5336592820000021, 49.4035005049999967 53.5339121640000002)
RD_EL_SHAPE2 = "0102000020E6100000020000003E26E5FD5EB34840CCB285F24EC44A407E7290E7A5B3484086A8D93B57C44A40"
# LINESTRING (41.2296153679999975 58.3978617530000008, 41.2274718250000021 58.3971518990000007)
# length = 148.200207338 meters
RD_EL_SHAPE3 = "0102000020E610000002000000081C5009649D44406CBB4822ED324D407791F8CB1D9D4440E9DF98DFD5324D40"


def make_count_job(statface_client, job, tables):
    return eval_report.make_job(
        job, 'd', statface_client, '2019-01-01', c.COUNT_REPORT_DESCRIPTOR,
        jo.DEFAULT_YMAPSDF_PATH, jo.DEFAULT_REGIONS, tables
    )


def make_length_job(statface_client, job, tables):
    return eval_report.make_job(
        job, 'd', statface_client, '2019-01-01', c.LENGTH_REPORT_DESCRIPTOR,
        jo.DEFAULT_YMAPSDF_PATH, jo.DEFAULT_REGIONS, tables
    )
