import common
from nile.api.v1 import (
    clusters,
    statface,
    Record
)
import pytest


@pytest.fixture
def statface_client():
    return statface.client.MockStatfaceClient()


@pytest.fixture
def job():
    cluster = clusters.MockCluster()
    return cluster.job()


@pytest.fixture
def major_regions():
    return [
        Record(region_id='10000',  major_id='10000', region_tree='\t10000\t'),
        # Россия, Центральный федеральный округ
        Record(region_id='3', major_id='10000', region_tree='\t10000\t'),
        Record(region_id='3', major_id='225', region_tree='\t10000\t225\t'),
        Record(region_id='3', major_id='3', region_tree='\t10000\t225\t3\t'),
        Record(region_id='3', major_id='999999000', region_tree='\t10000\t225\t999999000\t'),
        # Россия, Московская область
        Record(region_id='1', major_id='10000', region_tree='\t10000\t'),
        Record(region_id='1', major_id='225', region_tree='\t10000\t225\t'),
        Record(region_id='1', major_id='3', region_tree='\t10000\t225\t3\t'),
        Record(region_id='1', major_id='1', region_tree='\t10000\t225\t3\t1\t'),
        Record(region_id='1', major_id='999999000', region_tree='\t10000\t225\t999999000\t'),

        # Владимир
        Record(region_id='192', major_id='10000', region_tree='\t10000\t'),
        Record(region_id='192', major_id='999999003', region_tree='\t10000\t225\t999999003\t'),

        # Земля/Казахстан/Алматинская область
        Record(region_id='116783', major_id='10000', region_tree='\t10000\t'),
        Record(region_id='116783', major_id='159',   region_tree='\t10000\t159\t'),
        Record(region_id='116783', major_id='29406', region_tree='\t10000\t159\t29406\t'),

        Record(region_id='116889', major_id='10000', region_tree='\t10000\t'),
        Record(region_id='108177', major_id='10000', region_tree='\t10000\t'),
        Record(region_id='114577', major_id='10000', region_tree='\t10000\t'),

        # Земля/Россия/Приволжский федеральный округ/Самарская область/Тольятти
        Record(region_id='240',    major_id='10000', region_tree='\t10000\t'),
        Record(region_id='240',    major_id='225',   region_tree='\t10000\t225\t'),
        Record(region_id='240',    major_id='40',    region_tree='\t10000\t225\t40\t'),
        Record(region_id='240',    major_id='11131', region_tree='\t10000\t225\t40\t11131\t'),
        # Земля/Россия/350K+ (Тольятти)
        Record(region_id='240', major_id='999999004', region_tree='\t10000\t225\t999999004\t'),
        Record(region_id='240', major_id='240',       region_tree='\t10000\t225\t999999004\t240\t'),

        Record(region_id='98839',  major_id='10000', region_tree='\t10000\t'),
    ]


@pytest.fixture
def addr():
    return [
        Record(node_id='node_id1'),
        Record(node_id='node_id2'),
    ]


@pytest.fixture
def node():
    return [
        Record(node_id='node_id1', **common.POINT_SHAPE1),
        Record(node_id='node_id2', **common.POINT_SHAPE2),
    ]


@pytest.fixture
def bld():
    return [
        Record(bld_id='bld_id1'),
        Record(bld_id='bld_id2'),
        Record(bld_id='bld_id3'),
    ]


@pytest.fixture
def bld_geom():
    return [
        Record(bld_id='bld_id1', shape=common.BLD_SHAPE),
        Record(bld_id='bld_id3', shape=common.BLD_SHAPE2)
    ]


@pytest.fixture
def cond():
    return [
        Record(cond_id=1, cond_type=14, cond_seq_id=1, access_id=63),
        Record(cond_id=2, cond_type=16, cond_seq_id=1, access_id=12),
        Record(cond_id=3, cond_type=22, cond_seq_id=2, access_id=8),
        Record(cond_id=4, cond_type=1,  cond_seq_id=1, access_id=11),
        Record(cond_id=5, cond_type=1,  cond_seq_id=3, access_id=11),
    ]


@pytest.fixture
def cond_rd_seq():
    return [
        Record(cond_seq_id=1, rd_jc_id=101,  rd_el_id=1104, seq_num=0),
        Record(cond_seq_id=1, rd_jc_id=None, rd_el_id=1101, seq_num=1),
        Record(cond_seq_id=2, rd_jc_id=102,  rd_el_id=1103, seq_num=0),
        Record(cond_seq_id=2, rd_jc_id=None, rd_el_id=1107, seq_num=1),
        Record(cond_seq_id=2, rd_jc_id=103,  rd_el_id=1108, seq_num=2),
        Record(cond_seq_id=3, rd_jc_id=101,  rd_el_id=1100, seq_num=0),
        Record(cond_seq_id=3, rd_jc_id=None, rd_el_id=1100, seq_num=1),
    ]


@pytest.fixture
def rd_jc():
    return [
        Record(rd_jc_id=101, shape=common.POINT_SHAPE1['shape']),                          # x=80.66205921,   y=43.30768321,
        Record(rd_jc_id=102, shape=common.POINT_SHAPE2['shape']),                          # x=131.299715718, y=43.453289345,
        Record(rd_jc_id=103, shape='0101000020E6100000803DA0180B894640CA605A0E13AE4340'),  # x=45.070651129,  y=39.359956545,
        Record(rd_jc_id=105, shape='0101000020E6100000A2072FDB3D354D4023B70D40F6CF4240'),  # x=58.415950201,  y=37.62470246,
    ]


@pytest.fixture
def cond_vehicle_restriction():
    return [
        Record(cond_id=1, vehicle_restriction_id=1),
        Record(cond_id=1, vehicle_restriction_id=2),
        Record(cond_id=2, vehicle_restriction_id=2),
        Record(cond_id=3, vehicle_restriction_id=3),
    ]


@pytest.fixture
def vehicle_restriction():
    return [
        Record(
            vehicle_restriction_id=1,
            weight_limit=2,
            axle_weight_limit=None,
            max_weight_limit=None,
            height_limit=3,
            width_limit=None,
            length_limit=None,
            payload_limit=None,
            min_eco_class=None,
            trailer_not_allowed=False
            ),
        Record(
            vehicle_restriction_id=2,
            weight_limit=None,
            axle_weight_limit=None,
            max_weight_limit=3,
            height_limit=None,
            width_limit=None,
            length_limit=None,
            payload_limit=1,
            min_eco_class=None,
            trailer_not_allowed=True
            ),
        Record(
            vehicle_restriction_id=3,
            weight_limit=None,
            axle_weight_limit=None,
            max_weight_limit=None,
            height_limit=3,
            width_limit=1,
            length_limit=None,
            payload_limit=None,
            min_eco_class=3,
            trailer_not_allowed=False
            ),
    ]
