import common
from nile.api.v1 import (
    local,
    Record
)


def test_cond_restricted_count(statface_client, job, major_regions):
    job = common.make_count_job(statface_client, job, ['cond'])

    cond_vehicle_restriction = [
        Record(cond_id=1, vehicle_restriction_id=1),
        Record(cond_id=1, vehicle_restriction_id=2),
        Record(cond_id=2, vehicle_restriction_id=2),
        Record(cond_id=3, vehicle_restriction_id=3),
    ]

    cond = [
        Record(cond_id=1, cond_type=14, cond_seq_id=1, access_id=63),
        Record(cond_id=2, cond_type=16, cond_seq_id=1, access_id=12),
        Record(cond_id=3, cond_type=22, cond_seq_id=2, access_id=8),
        Record(cond_id=4, cond_type=1,  cond_seq_id=1, access_id=11),
        Record(cond_id=5, cond_type=1,  cond_seq_id=3, access_id=11),
    ]

    cond_rd_seq = [
        Record(cond_seq_id=1, rd_jc_id=101,  rd_el_id=1104, seq_num=0),
        Record(cond_seq_id=1, rd_jc_id=None, rd_el_id=1101, seq_num=1),
        Record(cond_seq_id=2, rd_jc_id=102,  rd_el_id=1103, seq_num=0),
        Record(cond_seq_id=2, rd_jc_id=None, rd_el_id=1107, seq_num=1),
        Record(cond_seq_id=2, rd_jc_id=103,  rd_el_id=1108, seq_num=2),
        Record(cond_seq_id=3, rd_jc_id=101,  rd_el_id=1100, seq_num=0),
        Record(cond_seq_id=3, rd_jc_id=None, rd_el_id=1100, seq_num=1),
    ]

    rd_jc = [
        Record(rd_jc_id=101, shape=common.POINT_SHAPE1['shape']),                          # x=80.66205921,   y=43.30768321,
        Record(rd_jc_id=102, shape=common.POINT_SHAPE2['shape']),                          # x=131.299715718, y=43.453289345,
        Record(rd_jc_id=103, shape='0101000020E6100000803DA0180B894640CA605A0E13AE4340'),  # x=45.070651129,  y=39.359956545,
        Record(rd_jc_id=105, shape='0101000020E6100000A2072FDB3D354D4023B70D40F6CF4240'),  # x=58.415950201,  y=37.62470246,
    ]

    cond_with_restriction = []
    counted_cond_by_restricted = []

    job.local_run(
        sources={
            'cond': local.StreamSource(cond),
            'cond_vehicle_restriction': local.StreamSource(cond_vehicle_restriction),
            'cond_rd_seq': local.StreamSource(cond_rd_seq),
            'rd_jc': local.StreamSource(rd_jc),
            'major_regions': local.StreamSource(major_regions),
        },
        sinks={
            'cond_with_restriction': local.ListSink(cond_with_restriction),
            'counted_cond_by_restricted': local.ListSink(counted_cond_by_restricted)
        }
    )

    assert sorted(cond_with_restriction) == sorted([
        Record(
            access_id=11, cond_id=4, cond_seq_id=1, cond_type=1, count=1,
            rd_el_id=1104, rd_jc_id=101, region_id='116783', restricted=False,
            seq_num=0, shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540'
        ),
        Record(
            access_id=8, cond_id=3, cond_seq_id=2, cond_type=22, count=1,
            rd_el_id=1103, rd_jc_id=102, region_id='116889', restricted=True,
            seq_num=0, shape='0101000020E610000007DD6A45976960403C33A06205BA4540',
            vehicle_restriction_id=3
        ),
        Record(
            access_id=12, cond_id=2, cond_seq_id=1, cond_type=16, count=1,
            rd_el_id=1104, rd_jc_id=101, region_id='116783', restricted=True,
            seq_num=0, shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540',
            vehicle_restriction_id=2
        ),
        Record(
            access_id=63, cond_id=1, cond_seq_id=1, cond_type=14, count=1,
            rd_el_id=1104, rd_jc_id=101, region_id='116783', restricted=True,
            seq_num=0, shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540',
            vehicle_restriction_id=1
        )
    ])

    assert sorted(counted_cond_by_restricted) == sorted([
        Record(category='cond restricted=True',  count=3, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond restricted=True',  count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond restricted=True',  count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
        Record(category='cond restricted=False',  count=1, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond restricted=False',  count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond restricted=False',  count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t')
    ])


def test_cond_restriction_type_count(statface_client, job, major_regions):
    job = common.make_count_job(statface_client, job, ['cond'])

    cond_vehicle_restriction = [
        Record(cond_id=1, vehicle_restriction_id=1),
        Record(cond_id=1, vehicle_restriction_id=2),
        Record(cond_id=2, vehicle_restriction_id=2),
        Record(cond_id=3, vehicle_restriction_id=3),
    ]

    vehicle_restriction = [
        Record(
            vehicle_restriction_id=1,
            weight_limit=2,
            axle_weight_limit=None,
            max_weight_limit=None,
            height_limit=3,
            width_limit=None,
            length_limit=None,
            payload_limit=None,
            min_eco_class=None,
            trailer_not_allowed=False
            ),
        Record(
            vehicle_restriction_id=2,
            weight_limit=None,
            axle_weight_limit=None,
            max_weight_limit=3,
            height_limit=None,
            width_limit=None,
            length_limit=None,
            payload_limit=1,
            min_eco_class=None,
            trailer_not_allowed=True
            ),
        Record(
            vehicle_restriction_id=3,
            weight_limit=None,
            axle_weight_limit=None,
            max_weight_limit=1,
            height_limit=3,
            width_limit=1,
            length_limit=None,
            payload_limit=None,
            min_eco_class=3,
            trailer_not_allowed=False
            ),
    ]

    cond = [
        Record(cond_id=1, cond_type=14, cond_seq_id=1, access_id=63),
        Record(cond_id=2, cond_type=16, cond_seq_id=1, access_id=12),
        Record(cond_id=3, cond_type=22, cond_seq_id=2, access_id=8),
        Record(cond_id=4, cond_type=1,  cond_seq_id=1, access_id=11),
        Record(cond_id=5, cond_type=1,  cond_seq_id=3, access_id=11),
    ]

    cond_rd_seq = [
        Record(cond_seq_id=1, rd_jc_id=101,  rd_el_id=1104, seq_num=0),
        Record(cond_seq_id=1, rd_jc_id=None, rd_el_id=1101, seq_num=1),
        Record(cond_seq_id=2, rd_jc_id=102,  rd_el_id=1103, seq_num=0),
        Record(cond_seq_id=2, rd_jc_id=None, rd_el_id=1107, seq_num=1),
        Record(cond_seq_id=2, rd_jc_id=103,  rd_el_id=1108, seq_num=2),
        Record(cond_seq_id=3, rd_jc_id=101,  rd_el_id=1100, seq_num=0),
        Record(cond_seq_id=3, rd_jc_id=None, rd_el_id=1100, seq_num=1),
    ]

    rd_jc = [
        Record(rd_jc_id=101, shape=common.POINT_SHAPE1['shape']),                          # x=80.66205921,   y=43.30768321,
        Record(rd_jc_id=102, shape=common.POINT_SHAPE2['shape']),                          # x=131.299715718, y=43.453289345,
        Record(rd_jc_id=103, shape='0101000020E6100000803DA0180B894640CA605A0E13AE4340'),  # x=45.070651129,  y=39.359956545,
        Record(rd_jc_id=105, shape='0101000020E6100000A2072FDB3D354D4023B70D40F6CF4240'),  # x=58.415950201,  y=37.62470246,
    ]

    cond_prepare_max_weight_limit_value = []
    cond_prepare_payload_limit_value = []
    cond_prepare_max_weight_limit_all = []
    cond_prepare_payload_limit_all = []
    cond_prepare_trailer_not_allowed_value = []
    cond_restriction_max_weight_limit = []
    cond_restriction_payload_limit = []
    cond_restriction_trailer_not_allowed = []

    job.local_run(
        sources={
            'cond': local.StreamSource(cond),
            'cond_vehicle_restriction': local.StreamSource(cond_vehicle_restriction),
            'cond_rd_seq': local.StreamSource(cond_rd_seq),
            'rd_jc': local.StreamSource(rd_jc),
            'major_regions': local.StreamSource(major_regions),
            'vehicle_restriction': local.StreamSource(vehicle_restriction)
        },
        sinks={
            'cond_prepare_max_weight_limit_value': local.ListSink(cond_prepare_max_weight_limit_value),
            'cond_prepare_payload_limit_value': local.ListSink(cond_prepare_payload_limit_value),
            'cond_prepare_max_weight_limit_all': local.ListSink(cond_prepare_max_weight_limit_all),
            'cond_prepare_payload_limit_all': local.ListSink(cond_prepare_payload_limit_all),
            'cond_prepare_trailer_not_allowed_value': local.ListSink(cond_prepare_trailer_not_allowed_value),
            'cond_restriction_max_weight_limit': local.ListSink(cond_restriction_max_weight_limit),
            'cond_restriction_payload_limit': local.ListSink(cond_restriction_payload_limit),
            'cond_restriction_trailer_not_allowed': local.ListSink(cond_restriction_trailer_not_allowed),
        }
    )

    assert sorted(cond_prepare_max_weight_limit_all) == sorted([
        Record(
            access_id=8, axle_weight_limit=None, cond_id=3, cond_seq_id=2,
            cond_type=22, count=1, max_weight_limit='all', height_limit=3,
            length_limit=None, min_eco_class=3, payload_limit=None,
            rd_el_id=1103, rd_jc_id=102, region_id='116889', seq_num=0,
            shape='0101000020E610000007DD6A45976960403C33A06205BA4540',
            trailer_not_allowed=False, vehicle_restriction_id=3,
            weight_limit=None, width_limit=1
        ),
        Record(
            access_id=12, axle_weight_limit=None, cond_id=2, cond_seq_id=1,
            cond_type=16, count=1, max_weight_limit='all', height_limit=None,
            length_limit=None, min_eco_class=None, payload_limit=1,
            rd_el_id=1104, rd_jc_id=101, region_id='116783', seq_num=0,
            shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540',
            trailer_not_allowed=True, vehicle_restriction_id=2,
            weight_limit=None, width_limit=None
        ),
        Record(
            access_id=63, axle_weight_limit=None, cond_id=1, cond_seq_id=1,
            cond_type=14, count=1, max_weight_limit='all', height_limit=None,
            length_limit=None, min_eco_class=None, payload_limit=1,
            rd_el_id=1104, rd_jc_id=101, region_id='116783', seq_num=0,
            shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540',
            trailer_not_allowed=True, vehicle_restriction_id=2,
            weight_limit=None, width_limit=None
        )
    ])

    assert sorted(cond_prepare_payload_limit_all) == sorted([
        Record(
            access_id=12, axle_weight_limit=None, cond_id=2, cond_seq_id=1,
            cond_type=16, count=1, height_limit=None, length_limit=None,
            max_weight_limit=3, min_eco_class=None, payload_limit='all',
            rd_el_id=1104, rd_jc_id=101, region_id='116783', seq_num=0,
            shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540',
            trailer_not_allowed=True, vehicle_restriction_id=2,
            weight_limit=None, width_limit=None
        ),
        Record(
            access_id=63, axle_weight_limit=None, cond_id=1, cond_seq_id=1,
            cond_type=14, count=1, height_limit=None, length_limit=None,
            max_weight_limit=3, min_eco_class=None, payload_limit='all',
            rd_el_id=1104, rd_jc_id=101, region_id='116783', seq_num=0,
            shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540',
            trailer_not_allowed=True, vehicle_restriction_id=2,
            weight_limit=None, width_limit=None
        )
    ])

    assert sorted(cond_prepare_max_weight_limit_value) == sorted([
        Record(
            access_id=8, axle_weight_limit=None, cond_id=3, cond_seq_id=2,
            cond_type=22, count=1, height_limit=3, length_limit=None,
            max_weight_limit=1, min_eco_class=3, payload_limit=None,
            rd_el_id=1103, rd_jc_id=102, region_id='116889', seq_num=0,
            shape='0101000020E610000007DD6A45976960403C33A06205BA4540',
            trailer_not_allowed=False, vehicle_restriction_id=3,
            weight_limit=None, width_limit=1
        ),
        Record(
            access_id=12, axle_weight_limit=None, cond_id=2, cond_seq_id=1,
            cond_type=16, count=1, height_limit=None, length_limit=None,
            max_weight_limit=3, min_eco_class=None, payload_limit=1,
            rd_el_id=1104, rd_jc_id=101, region_id='116783', seq_num=0,
            shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540',
            trailer_not_allowed=True, vehicle_restriction_id=2,
            weight_limit=None, width_limit=None
        ),
        Record(
            access_id=63, axle_weight_limit=None, cond_id=1, cond_seq_id=1,
            cond_type=14, count=1, height_limit=None, length_limit=None,
            max_weight_limit=3, min_eco_class=None, payload_limit=1,
            rd_el_id=1104, rd_jc_id=101, region_id='116783', seq_num=0,
            shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540',
            trailer_not_allowed=True, vehicle_restriction_id=2,
            weight_limit=None, width_limit=None
        )
    ])

    assert sorted(cond_prepare_payload_limit_value) == sorted([
        Record(
            access_id=12, axle_weight_limit=None, cond_id=2, cond_seq_id=1,
            cond_type=16, count=1, height_limit=None, length_limit=None,
            max_weight_limit=3, min_eco_class=None, payload_limit=1,
            rd_el_id=1104, rd_jc_id=101, region_id='116783', seq_num=0,
            shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540',
            trailer_not_allowed=True, vehicle_restriction_id=2,
            weight_limit=None, width_limit=None
        ),
        Record(
            access_id=63, axle_weight_limit=None, cond_id=1, cond_seq_id=1,
            cond_type=14, count=1, height_limit=None, length_limit=None,
            max_weight_limit=3, min_eco_class=None, payload_limit=1,
            rd_el_id=1104, rd_jc_id=101, region_id='116783', seq_num=0,
            shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540',
            trailer_not_allowed=True, vehicle_restriction_id=2,
            weight_limit=None, width_limit=None
        )
    ])

    assert sorted(cond_prepare_trailer_not_allowed_value) == sorted([
        Record(
            access_id=12, axle_weight_limit=None, cond_id=2, cond_seq_id=1,
            cond_type=16, count=1, height_limit=None, length_limit=None,
            max_weight_limit=3, min_eco_class=None, payload_limit=1,
            rd_el_id=1104, rd_jc_id=101, region_id='116783', seq_num=0,
            shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540',
            trailer_not_allowed=True, vehicle_restriction_id=2,
            weight_limit=None, width_limit=None
        ),
        Record(
            access_id=63, axle_weight_limit=None, cond_id=1, cond_seq_id=1,
            cond_type=14, count=1, height_limit=None, length_limit=None,
            max_weight_limit=3, min_eco_class=None, payload_limit=1,
            rd_el_id=1104, rd_jc_id=101, region_id='116783', seq_num=0,
            shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540',
            trailer_not_allowed=True, vehicle_restriction_id=2,
            weight_limit=None, width_limit=None
        )
    ])

    assert sorted(cond_restriction_max_weight_limit) == sorted([
        Record(category='cond max_weight_limit=1', count=1, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond max_weight_limit=3', count=2, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond max_weight_limit=3', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond max_weight_limit=3', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
        Record(category='cond max_weight_limit=all', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond max_weight_limit=all', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
        Record(category='cond max_weight_limit=all', count=3, fielddate='2019-01-01', region_tree='\t10000\t')
    ])

    assert sorted(cond_restriction_payload_limit) == sorted([
        Record(category='cond payload_limit=1', count=2, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond payload_limit=1', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond payload_limit=1', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
        Record(category='cond payload_limit=all', count=2, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond payload_limit=all', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond payload_limit=all', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
    ])

    assert sorted(cond_restriction_trailer_not_allowed) == sorted([
        Record(category='cond trailer_not_allowed=True', count=2, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond trailer_not_allowed=True', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond trailer_not_allowed=True', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
        Record(category='cond trailer_not_allowed=all', count=2, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond trailer_not_allowed=all', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond trailer_not_allowed=all', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t')
    ])


def test_cond_count(statface_client, job, cond, cond_rd_seq, rd_jc, major_regions, cond_vehicle_restriction, vehicle_restriction):
    job = common.make_count_job(statface_client, job, ['cond'])

    result_cond = []
    job.local_run(
        sources={
            'cond': local.StreamSource(cond),
            'cond_rd_seq': local.StreamSource(cond_rd_seq),
            'rd_jc': local.StreamSource(rd_jc),
            'major_regions': local.StreamSource(major_regions)
        },
        sinks={
            'result_cond': local.ListSink(result_cond)
        }
    )

    assert sorted(result_cond) == sorted([
        Record(category='cond all',     count=4, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond all',     count=3, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond all',     count=3, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
        Record(category='cond cond_type=1',  count=1, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond cond_type=1',  count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond cond_type=1',  count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
        Record(category='cond cond_type=1 access_type pedestrian',  count=1, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond cond_type=1 access_type pedestrian',  count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond cond_type=1 access_type pedestrian',  count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
        Record(category='cond cond_type=1 access_type bus',    count=1, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond cond_type=1 access_type bus',    count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond cond_type=1 access_type bus',    count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
        Record(category='cond cond_type=1 access_type auto',   count=1, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond cond_type=1 access_type auto',   count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond cond_type=1 access_type auto',   count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
        Record(category='cond cond_type=14',  count=1, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond cond_type=14',  count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond cond_type=14',  count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
        Record(category='cond cond_type=16',  count=1, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='cond cond_type=16',  count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='cond cond_type=16',  count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
        Record(category='cond cond_type=22',  count=1, fielddate='2019-01-01', region_tree='\t10000\t')
    ])


def test_addr_and_bld_count(statface_client, job, addr, bld, bld_geom, node, major_regions):
    job = common.make_count_job(statface_client, job, ['addr', 'bld'])

    addr_with_region = []
    bld_with_region = []
    result_addr = []
    result_bld = []
    job.local_run(
        sources={
            'addr': local.StreamSource(addr),
            'bld': local.StreamSource(bld),
            'bld_geom': local.StreamSource(bld_geom),
            'node': local.StreamSource(node),
            'major_regions': local.StreamSource(major_regions),
        },
        sinks={
            'counted_addr all': local.ListSink(result_addr),
            'counted_bld all': local.ListSink(result_bld),
            'addr_with_region': local.ListSink(addr_with_region),
            'bld_with_region': local.ListSink(bld_with_region),
        }
    )
    assert sorted(addr_with_region) == sorted([
        Record(node_id='node_id1', region_id='116783', shape='0101000020E6100000CCBD972D5F2A5440393DD62962A74540', x=80.66205921,   y=43.30768321),
        Record(node_id='node_id2', region_id='116889', shape='0101000020E610000007DD6A45976960403C33A06205BA4540', x=131.299715718, y=43.453289345),
    ])

    assert sorted(bld_with_region) == sorted([
        Record(bld_id='bld_id1', region_id='114577', shape=common.BLD_SHAPE),
        Record(bld_id='bld_id2', region_id='10000'),
        Record(bld_id='bld_id3', region_id='114566', shape=common.BLD_SHAPE2),
    ])

    assert sorted(result_addr) == sorted([
        Record(category='addr all', count=2, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='addr all', count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t'),
        Record(category='addr all', count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),
    ])

    assert sorted(result_bld) == sorted([
        Record(category='bld all', count=3, fielddate='2019-01-01', region_tree='\t10000\t'),
    ])
