import common
import pytest

from nile.api.v1 import (
    local,
    Record
)


@pytest.fixture
def flat_range_sources(node, major_regions):
    return {
        'entrance_flat_range': local.StreamSource([
            Record(flat_range_id=1, flat_first='1', flat_last='10', ft_id=1, is_exact=True),
            Record(flat_range_id=2, flat_first='11', flat_last='11', ft_id=2, is_exact=True),
            Record(flat_range_id=3, flat_first='12А', flat_last='12А', ft_id=3, is_exact=True),
            Record(flat_range_id=4, flat_first='21', flat_last='30', ft_id=4, is_exact=True),
            Record(flat_range_id=5, flat_first='31', flat_last='35', ft_id=4, is_exact=False),
            Record(flat_range_id=6, flat_first='Б', flat_last='Б', ft_id=4, is_exact=True),
        ]),
        'ft_center': local.StreamSource([
            Record(ft_id=1, node_id='node_id1'),
            Record(ft_id=2, node_id='node_id1'),
            Record(ft_id=3, node_id='node_id1'),
            Record(ft_id=4, node_id='node_id1'),
            Record(ft_id=5, node_id='node_id2'),
            Record(ft_id=6, node_id='node_id2'),
        ]),
        'node': local.StreamSource(node),
        'major_regions': local.StreamSource(major_regions),
    }


def test_flat_range(statface_client, job, flat_range_sources):
    job = common.make_count_job(statface_client, job, ['entrance_flat_range'])

    result_flat_range = []
    job.local_run(
        sources=flat_range_sources,
        sinks={
            'result_flat_range': local.ListSink(result_flat_range),
        }
    )

    assert sorted(result_flat_range) == sorted([
        Record(category='ft ft_type=urban-entrance flat_range exact', count=3, fielddate='2019-01-01', region_tree='\t10000\t'),                  # Земля
        Record(category='ft ft_type=urban-entrance flat_range exact', count=3, fielddate='2019-01-01', region_tree='\t10000\t159\t'),             # Земля/Казахстан
        Record(category='ft ft_type=urban-entrance flat_range exact', count=3, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),      # Земля/Казахстан/Алматинская область
        Record(category='ft ft_type=urban-entrance flat_range not exact', count=1, fielddate='2019-01-01', region_tree='\t10000\t'),              # Земля
        Record(category='ft ft_type=urban-entrance flat_range not exact', count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t'),         # Земля/Казахстан
        Record(category='ft ft_type=urban-entrance flat_range not exact', count=1, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),  # Земля/Казахстан/Алматинская область
        Record(category='flat', count=28, fielddate='2019-01-01', region_tree='\t10000\t'),                                                       # Земля
        Record(category='flat', count=28, fielddate='2019-01-01', region_tree='\t10000\t159\t'),                                                  # Земля/Казахстан
        Record(category='flat', count=28, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),                                           # Земля/Казахстан/Алматинская область
    ])
