import common
import pytest

from nile.api.v1 import (
    local,
    Record
)


@pytest.fixture
def poi_entrance_assigned_sources(node, major_regions):
    return {
        'ft_ft': local.StreamSource([
            Record(master_ft_id=1, slave_ft_id=4, role='poi-entrance-assigned'),
            Record(master_ft_id=1, slave_ft_id=5, role='poi-entrance-assigned'),
            Record(master_ft_id=1, slave_ft_id=6, role='poi-entrance-assigned'),
            Record(master_ft_id=2, slave_ft_id=6, role='poi-entrance-assigned'),
            Record(master_ft_id=2, slave_ft_id=7, role='poi-entrance-assigned'),
            Record(master_ft_id=3, slave_ft_id=8, role='poi-entrance-assigned'),
        ]),
        'ft_center': local.StreamSource([
            Record(ft_id=1, node_id='node_id1'),
            Record(ft_id=2, node_id='node_id1'),
            Record(ft_id=3, node_id='node_id2'),
            Record(ft_id=4, node_id='node_id1'),
            Record(ft_id=5, node_id='node_id1'),
            Record(ft_id=6, node_id='node_id1'),
            Record(ft_id=7, node_id='node_id2'),
            Record(ft_id=8, node_id='node_id2'),
        ]),
        'node': local.StreamSource(node),
        'major_regions': local.StreamSource(major_regions),
    }


def test_poi_entrance_assigned(statface_client, job, poi_entrance_assigned_sources):
    job = common.make_count_job(statface_client, job, ['ft_ft'])

    result_poi_entrance_assigned = []
    job.local_run(
        sources=poi_entrance_assigned_sources,
        sinks={
            'result_poi_entrance_assigned': local.ListSink(result_poi_entrance_assigned),
        }
    )

    assert sorted(result_poi_entrance_assigned) == sorted([
        Record(category='ft poi-with-entrances', count=3, fielddate='2019-01-01', region_tree='\t10000\t'),                  # Земля
        Record(category='ft poi-with-entrances', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t'),             # Земля/Казахстан
        Record(category='ft poi-with-entrances', count=2, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),      # Земля/Казахстан/Алматинская область
        Record(category='ft entrances-for-poi', count=5, fielddate='2019-01-01', region_tree='\t10000\t'),              # Земля
        Record(category='ft entrances-for-poi', count=3, fielddate='2019-01-01', region_tree='\t10000\t159\t'),         # Земля/Казахстан
        Record(category='ft entrances-for-poi', count=3, fielddate='2019-01-01', region_tree='\t10000\t159\t29406\t'),  # Земля/Казахстан/Алматинская область
    ])
