import common

from nile.api.v1 import (
    local,
    Record
)
import pytest


@pytest.fixture
def rd_el_sources(major_regions):
    return {
        'rd_el': local.StreamSource([
            Record(rd_el_id='rd_el_id1', fc=1, shape=common.RD_EL_SHAPE1, access_id=46),
            Record(rd_el_id='rd_el_id2', fc=1, shape=common.RD_EL_SHAPE1, access_id=46),
            Record(rd_el_id='rd_el_id3', fc=1, shape=common.RD_EL_SHAPE1, access_id=46),
            Record(rd_el_id='rd_el_id4', fc=1, shape=common.RD_EL_SHAPE1, access_id=40),
            Record(rd_el_id='rd_el_id5', fc=2, shape=common.RD_EL_SHAPE1, access_id=42),
            Record(rd_el_id='rd_el_id6', fc=2, shape=common.RD_EL_SHAPE2, access_id=46),
            Record(rd_el_id='rd_el_id7', fc=3, shape=common.RD_EL_SHAPE3, access_id=63)
        ]),
        'rd_rd_el': local.StreamSource([
            Record(rd_id=1, rd_el_id='rd_el_id1'),
            Record(rd_id=2, rd_el_id='rd_el_id6'),
        ]),
        'major_regions': local.StreamSource(major_regions),
        'rd_el_vehicle_restriction': local.StreamSource([
            Record(rd_el_id='rd_el_id1', vehicle_restriction_id=1),
            Record(rd_el_id='rd_el_id1', vehicle_restriction_id=2),
            Record(rd_el_id='rd_el_id2', vehicle_restriction_id=1),
            Record(rd_el_id='rd_el_id3', vehicle_restriction_id=4),
            Record(rd_el_id='rd_el_id4', vehicle_restriction_id=3)
        ]),
        'vehicle_restriction': local.StreamSource([
            Record(vehicle_restriction_id=1, universal_id='truck_3_5'),
            Record(vehicle_restriction_id=2, universal_id='msk_mkad'),
            Record(vehicle_restriction_id=3, universal_id='spb_kad'),
            Record(vehicle_restriction_id=4, universal_id='msk_ttk'),
        ])
    }


def test_rd_el_region(statface_client, job, rd_el_sources):
    job = common.make_length_job(statface_client, job, ['rd_el'])

    rd_el_with_region = []

    job.local_run(
        sources=rd_el_sources,
        sinks={
            'rd_el_with_region': local.ListSink(rd_el_with_region),
        }
    )
    assert sorted(rd_el_with_region) == sorted([
        Record(access_id=46, fc=1, rd_el_id='rd_el_id1', region_id='108177', shape=common.RD_EL_SHAPE1),
        Record(access_id=46, fc=1, rd_el_id='rd_el_id2', region_id='108177', shape=common.RD_EL_SHAPE1),
        Record(access_id=46, fc=1, rd_el_id='rd_el_id3', region_id='108177', shape=common.RD_EL_SHAPE1),
        Record(access_id=40, fc=1, rd_el_id='rd_el_id4', region_id='108177', shape=common.RD_EL_SHAPE1),
        Record(access_id=42, fc=2, rd_el_id='rd_el_id5', region_id='108177', shape=common.RD_EL_SHAPE1),
        Record(access_id=46, fc=2, rd_el_id='rd_el_id6', region_id='240',    shape=common.RD_EL_SHAPE2),
        Record(access_id=63, fc=3, rd_el_id='rd_el_id7', region_id='98839',  shape=common.RD_EL_SHAPE3),
    ])


def test_rd_el_named(statface_client, job, rd_el_sources):
    job = common.make_count_job(statface_client, job, ['rd_el'])

    rd_el_with_named = []

    job.local_run(
        sources=rd_el_sources,
        sinks={
            'rd_el_with_named': local.ListSink(rd_el_with_named),
        }
    )
    assert sorted(rd_el_with_named) == sorted([
        Record(access_id=46, count=1, fc=1, named=True,  rd_el_id='rd_el_id1', rd_id=1, region_id='108177', shape=common.RD_EL_SHAPE1),
        Record(access_id=46, count=1, fc=1, named=False, rd_el_id='rd_el_id2',          region_id='108177', shape=common.RD_EL_SHAPE1),
        Record(access_id=46, count=1, fc=1, named=False, rd_el_id='rd_el_id3',          region_id='108177', shape=common.RD_EL_SHAPE1),
        Record(access_id=40, count=1, fc=1, named=False, rd_el_id='rd_el_id4',          region_id='108177', shape=common.RD_EL_SHAPE1),
        Record(access_id=42, count=1, fc=2, named=False, rd_el_id='rd_el_id5',          region_id='108177', shape=common.RD_EL_SHAPE1),
        Record(access_id=46, count=1, fc=2, named=True,  rd_el_id='rd_el_id6', rd_id=2, region_id='240',    shape=common.RD_EL_SHAPE2),
        Record(access_id=63, count=1, fc=3, named=False, rd_el_id='rd_el_id7',          region_id='98839',  shape=common.RD_EL_SHAPE3),
    ])


def test_count_rd_el_by_named(statface_client, job, rd_el_sources):
    job = common.make_count_job(statface_client, job, ['rd_el'])

    counted_rd_el_by_named = []

    job.local_run(
        sources=rd_el_sources,
        sinks={
            'counted_rd_el_by_named': local.ListSink(counted_rd_el_by_named),
        }
    )
    assert sorted(counted_rd_el_by_named) == sorted([
        Record(category='rd_el named=False', count=5, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el named=True',  count=2, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el named=True',  count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el named=True',  count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el named=True',  count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el named=True',  count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el named=True',  count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),
    ])


def test_count_rd_el_by_fc(statface_client, job, rd_el_sources):
    job = common.make_count_job(statface_client, job, ['rd_el'])

    counted_rd_el_by_fc = []

    job.local_run(
        sources=rd_el_sources,
        sinks={
            'counted_rd_el_by_fc': local.ListSink(counted_rd_el_by_fc),
        }
    )
    assert sorted(counted_rd_el_by_fc) == sorted([
        Record(category='rd_el fc=1', count=4, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el fc=2', count=2, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el fc=2', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el fc=2', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el fc=2', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el fc=2', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el fc=2', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),
        Record(category='rd_el fc=3', count=1, fielddate='2019-01-01', region_tree='\t10000\t'),
    ])


def test_rd_el_filters(statface_client, job, rd_el_sources):
    job = common.make_count_job(statface_client, job, ['rd_el'])

    result = []

    job.local_run(
        sources=rd_el_sources,
        sinks={
            'result_rd_el': local.ListSink(result),
        }
    )
    assert sorted(result) == sorted([
        Record(category='rd_el all', count=7, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el all', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el all', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el all', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el all', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el all', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),

        Record(category='rd_el auto', count=7, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el auto', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el auto', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el auto', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el auto', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el auto', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),

        Record(category='rd_el bicycle', count=1, fielddate='2019-01-01', region_tree='\t10000\t'),

        Record(category='rd_el bus', count=6, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el bus', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el bus', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el bus', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el bus', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el bus', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),

        Record(category='rd_el pedestrian', count=1, fielddate='2019-01-01', region_tree='\t10000\t'),

        Record(category='rd_el taxi', count=7, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el taxi', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el taxi', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el taxi', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el taxi', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el taxi', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),

        Record(category='rd_el truck', count=5, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el truck', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el truck', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el truck', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el truck', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el truck', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),

        Record(category='rd_el oneway', count=7, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el oneway', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el oneway', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el oneway', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el oneway', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el oneway', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),
    ])


def test_rd_el_full_result(statface_client, job, rd_el_sources):
    job = common.make_count_job(statface_client, job, ['rd_el'])

    result = []

    job.local_run(
        sources=rd_el_sources,
        sinks={
            'result_rd_el_full': local.ListSink(result),
        }
    )
    assert sorted(result) == sorted([
        Record(category='rd_el all', count=7, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el all', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el all', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el all', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el all', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el all', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),

        Record(category='rd_el auto', count=7, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el auto', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el auto', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el auto', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el auto', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el auto', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),

        Record(category='rd_el bicycle', count=1, fielddate='2019-01-01', region_tree='\t10000\t'),

        Record(category='rd_el bus', count=6, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el bus', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el bus', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el bus', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el bus', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el bus', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),

        Record(category='rd_el pedestrian', count=1, fielddate='2019-01-01', region_tree='\t10000\t'),

        Record(category='rd_el taxi', count=7, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el taxi', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el taxi', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el taxi', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el taxi', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el taxi', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),

        Record(category='rd_el truck', count=5, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el truck', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el truck', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el truck', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el truck', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el truck', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),

        Record(category='rd_el fc=1', count=4, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el fc=2', count=2, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el fc=2', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el fc=2', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el fc=2', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el fc=2', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el fc=2', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),
        Record(category='rd_el fc=3', count=1, fielddate='2019-01-01', region_tree='\t10000\t'),

        Record(category='rd_el named=False', count=5, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el named=True',  count=2, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el named=True',  count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el named=True',  count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el named=True',  count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el named=True',  count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el named=True',  count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),

        Record(category='rd_el oneway', count=7, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el oneway', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el oneway', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el oneway', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el oneway', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el oneway', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),

        Record(category='rd_el restricted=False', count=3, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el restricted=False', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el restricted=False', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el restricted=False', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el restricted=False', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el restricted=False', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),
        Record(category='rd_el restricted=True',  count=4, fielddate='2019-01-01', region_tree='\t10000\t'),

        Record(category='rd_el universal_id=False', count=3, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el universal_id=False', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t'),
        Record(category='rd_el universal_id=False', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el universal_id=False', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el universal_id=False', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el universal_id=False', count=1, fielddate='2019-01-01', region_tree='\t10000\t225\t999999004\t240\t'),
        Record(category='rd_el universal_id=truck_3_5',  count=2, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el universal_id=msk_mkad',  count=1, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el universal_id=spb_kad',  count=1, fielddate='2019-01-01', region_tree='\t10000\t'),
        Record(category='rd_el universal_id=msk_ttk',  count=1, fielddate='2019-01-01', region_tree='\t10000\t'),
    ])


def test_rd_el_length_filters(statface_client, job, rd_el_sources):
    job = common.make_length_job(statface_client, job, ['rd_el'])

    result = []

    job.local_run(
        sources=rd_el_sources,
        sinks={
            'result_rd_el': local.ListSink(result),
        }
    )

    assert sorted(result) == sorted([
        Record(category='rd_el all', fielddate='2019-01-01', length=637.1565708390932, region_tree='\t10000\t'),
        Record(category='rd_el all', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el all', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t999999004\t240\t'),
        Record(category='rd_el all', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t'),
        Record(category='rd_el all', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el all', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t40\t11131\t'),

        Record(category='rd_el auto',  fielddate='2019-01-01', length=637.1565708390932, region_tree='\t10000\t'),
        Record(category='rd_el auto',  fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t'),
        Record(category='rd_el auto',  fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el auto',  fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el auto',  fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el auto',  fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t999999004\t240\t'),
        Record(category='rd_el bicycle',    fielddate='2019-01-01', length=148.20020733787385, region_tree='\t10000\t'),
        Record(category='rd_el pedestrian', fielddate='2019-01-01', length=148.20020733787385, region_tree='\t10000\t'),
        Record(category='rd_el bus',   fielddate='2019-01-01', length=568.6107196662944, region_tree='\t10000\t'),
        Record(category='rd_el bus',   fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t'),
        Record(category='rd_el bus',   fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el bus',   fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el bus',   fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el bus',   fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t999999004\t240\t'),
        Record(category='rd_el truck', fielddate='2019-01-01', length=500.0648684934955, region_tree='\t10000\t'),
        Record(category='rd_el truck', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t'),
        Record(category='rd_el truck', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el truck', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el truck', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el truck', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t999999004\t240\t'),
        Record(category='rd_el taxi',  fielddate='2019-01-01', length=637.1565708390932, region_tree='\t10000\t'),
        Record(category='rd_el taxi',  fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t'),
        Record(category='rd_el taxi',  fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el taxi',  fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el taxi',  fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el taxi',  fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t999999004\t240\t'),

        Record(category='rd_el oneway', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t'),
        Record(category='rd_el oneway', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t40\t'),
        Record(category='rd_el oneway', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t40\t11131\t'),
        Record(category='rd_el oneway', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t999999004\t'),
        Record(category='rd_el oneway', fielddate='2019-01-01', length=146.2271076372251, region_tree='\t10000\t225\t999999004\t240\t'),
        Record(category='rd_el oneway', fielddate='2019-01-01', length=637.1565708390932, region_tree='\t10000\t'),
    ])
