import yt.wrapper as yt

from nile.api.v1 import (
    stream as ns,
    Job
)

import re
import requests
import typing as tp

GARDEN_BUILDS_URL: str = 'http://core-garden-server.maps.yandex.net/modules/ymapsdf/builds/?contour=stable'
YMAPSDF_PATH: str = '//home/maps/core/garden/stable/ymapsdf'
REGEX_SHIPMENT: str = r'^(\d{8})_\d+_\d+_\d+$'


def ymapsdf_incomplete_builds() -> tp.Set[str]:
    result = set()
    response = requests.get(GARDEN_BUILDS_URL)
    for build in response.json():
        if build['progress']['status'] != 'completed':
            result.add(build['properties']['shipping_date'])
    return result


def ymapsdf_latest_paths() -> tp.Dict[str, str]:
    shipments = sorted(yt.list(YMAPSDF_PATH))
    incomplete_builds = ymapsdf_incomplete_builds()
    region_to_shipment = {}
    for shipment in shipments:
        if not re.search(REGEX_SHIPMENT, shipment):
            continue
        if shipment in incomplete_builds:
            continue
        ymapsdf_regions = yt.list(yt.ypath.ypath_join(YMAPSDF_PATH, shipment))
        for ymapsdf_region in ymapsdf_regions:
            region_to_shipment[ymapsdf_region] = yt.ypath.ypath_join(
                YMAPSDF_PATH,
                shipment,
                ymapsdf_region)
    return region_to_shipment


def ymapsdf_table(
    job: Job,
    ymapsdf_paths: tp.Dict[str, str],
    stage: str,
    table_name: str,
    *fields_to_unique: tp.List[str]
) -> ns.Stream:
    return job.concat(*(
        job.table(yt.ypath.ypath_join(ymapsdf_path, stage, table_name))
        for ymapsdf_path in ymapsdf_paths.values()
    )).unique(*fields_to_unique)
