import common
import maps.wikimap.stat.kpi.poi_stat.lib.poi_stat as poi_stat

from maps.wikimap.stat.libs import nile_ut
from nile.api.v1 import Record


def test_make_raw_data():
    result = nile_ut.yt_run(
        poi_stat.make_raw_data,
        ft=nile_ut.Table([
            Record(ft_id=1, ft_type_id=1401, p_ft_id=1501, p_ft_type_id=2301),
            Record(ft_id=2, ft_type_id=1402, p_ft_id=1502, p_ft_type_id=2302),
            Record(ft_id=3, ft_type_id=1403),
            Record(ft_id=4, ft_type_id=1404),
        ]),
        ft_poi_attr=nile_ut.Table([
            Record(ft_id=1, position_quality=5),
            Record(ft_id=2, position_quality=4),
            Record(ft_id=3, position_quality=0),
            Record(ft_id=4),
        ]),
        ft_center=nile_ut.Table([
            Record(ft_id=1, node_id=1),
            Record(ft_id=2, node_id=2),
            Record(ft_id=3, node_id=3),
            Record(ft_id=4, node_id=4),
        ]),
        node=nile_ut.Table([
            Record(node_id=1, shape=common.POINT_NN_1),
            Record(node_id=2, shape=common.POINT_NN_1),
            Record(node_id=3, shape=common.POINT_MSK_1),
            Record(node_id=4, shape=common.POINT_MSK_2),
        ]),
        altay_data=nile_ut.Table([
            Record(ft_id=1, permalink_id='permalink_id_1', geom_altay=common.POINT_NN_1, is_closed=False),
            Record(ft_id=2, permalink_id='permalink_id_2', geom_altay=common.POINT_NN_2, is_closed=False),
            Record(ft_id=3, permalink_id='permalink_id_3', geom_altay=common.POINT_MSK_1, is_closed=True),
            Record(ft_id=5, permalink_id='permalink_id_5', geom_altay=common.POINT_MSK_1, is_closed=False),
            Record(ft_id=6, permalink_id='permalink_id_6', geom_altay=common.POINT_MSK_2, is_closed=True),
        ]),
        ft_source=nile_ut.Table([
            Record(ft_id=1, source_type_id=1, source_id='permalink_id_11'),
            Record(ft_id=1, source_type_id=3, source_id='mtr_id_1'),
            Record(ft_id=2, source_type_id=1, source_id='permalink_id_12'),
            Record(ft_id=3, source_type_id=3, source_id='mtr_id_3'),
        ])
    )

    assert sorted(result) == sorted([
        Record(
            ft_id=1, ft_type_id=1401,
            p_ft_id=1501, p_ft_type_id=2301,
            permalink_id='permalink_id_1', permalink_id_ymapsdf='permalink_id_11',
            geom_nk=common.POINT_NN_1, geom_altay=common.POINT_NN_1,
            dist=0.0, region_id=common.REGION_ID_NN,
            position_quality=5,
            is_closed=False
        ),
        Record(
            ft_id=2, ft_type_id=1402,
            p_ft_id=1502, p_ft_type_id=2302,
            permalink_id='permalink_id_2', permalink_id_ymapsdf='permalink_id_12',
            geom_nk=common.POINT_NN_1, geom_altay=common.POINT_NN_2,
            dist=common.DISTANCE_NN, region_id=common.REGION_ID_NN,
            position_quality=4,
            is_closed=False
        ),
        Record(
            ft_id=3, ft_type_id=1403,
            p_ft_id=None, p_ft_type_id=None,
            permalink_id='permalink_id_3', permalink_id_ymapsdf=None,
            geom_nk=common.POINT_MSK_1, geom_altay=common.POINT_MSK_1,
            dist=None, region_id=common.REGION_ID_MSK_1,
            position_quality=0,
            is_closed=True
        ),
        Record(
            ft_id=4, ft_type_id=1404,
            p_ft_id=None, p_ft_type_id=None,
            permalink_id=None, permalink_id_ymapsdf=None,
            geom_nk=common.POINT_MSK_2, geom_altay=None,
            dist=None, region_id=common.REGION_ID_MSK_2,
            position_quality=None,
            is_closed=None
        )
    ])


def test_calculate_metrics():
    result = nile_ut.yt_run(
        poi_stat.calculate_metrics,
        raw_data=nile_ut.Table([
            Record(
                ft_id=1, ft_type_id=1401,
                permalink_id='permalink_id_1', permalink_id_ymapsdf='permalink_id_1',
                geom_nk=common.POINT_NN_1, geom_altay=common.POINT_NN_1,
                dist=0.0, region_id=common.REGION_ID_NN,
                position_quality=5,
                is_closed=False
            ),
            Record(
                ft_id=2, ft_type_id=1402,
                permalink_id='permalink_id_1', permalink_id_ymapsdf='permalink_id_1',
                geom_nk=common.POINT_NN_1, geom_altay=common.POINT_NN_2,
                dist=common.DISTANCE_NN, region_id=common.REGION_ID_NN,
                position_quality=5,
                is_closed=False
            ),
            Record(
                ft_id=3, ft_type_id=1403,
                permalink_id='permalink_id_1', permalink_id_ymapsdf='permalink_id_1',
                geom_nk=common.POINT_MSK_1, geom_altay=common.POINT_MSK_1,
                dist=0.0, region_id=common.REGION_ID_MSK_1,
                position_quality=4,
                is_closed=False
            ),
            Record(
                ft_id=4, ft_type_id=1404,
                permalink_id='permalink_id_2', permalink_id_ymapsdf='permalink_id_2',
                geom_nk=common.POINT_MSK_1, geom_altay=common.POINT_MSK_2,
                dist=common.DISTANCE_MSK, region_id=common.REGION_ID_MSK_1,
                position_quality=4,
                is_closed=False
            ),
            Record(
                ft_id=5, ft_type_id=1405,
                permalink_id='permalink_id_1', permalink_id_ymapsdf='permalink_id_1',
                geom_nk=common.POINT_MSK_1, geom_altay=common.POINT_MSK_1,
                dist=None, region_id=common.REGION_ID_MSK_1,
                position_quality=0,
                is_closed=True
            ),
            Record(
                ft_id=6, ft_type_id=1406,
                permalink_id=None, permalink_id_ymapsdf=None,
                geom_nk=common.POINT_MSK_2, geom_altay=None,
                dist=None, region_id=common.REGION_ID_MSK_2,
                is_closed=False
            )
        ]),
        major_regions=nile_ut.Table(common.MAJOR_REGIONS),
        group_name='Все'
    )

    assert sorted(result) == sorted([
        Record(
            group='Все', region_name='Земля/Россия/Москва/Мещанский район',
            total_count=3, verified_count=2,
            to_close=1, no_permalink=0,
            ambiguous_permalinks=0, ambiguous_ft_ids=0,
            ambiguous_permalinks_ymapsdf=0, ambiguous_ft_ids_ymapsdf=0,
            dist_equal=1,
            dist_over_half_m=1, dist_over_5m=1, dist_over_10m=1,
            dist_over_20m=1, dist_over_50m=1, dist_over_100m=1,
            dist_over_500m=1,
            pos_quality_user=0, pos_quality_precise=2, pos_quality_empty=1
        ),
        Record(
            group='Все', region_name='Земля/Россия/Москва/Раменки',
            total_count=1, verified_count=0,
            to_close=0, no_permalink=1,
            ambiguous_permalinks=0, ambiguous_ft_ids=0,
            ambiguous_permalinks_ymapsdf=0, ambiguous_ft_ids_ymapsdf=0,
            dist_equal=0,
            dist_over_half_m=0, dist_over_5m=0, dist_over_10m=0,
            dist_over_20m=0, dist_over_50m=0, dist_over_100m=0,
            dist_over_500m=0,
            pos_quality_user=0, pos_quality_precise=0, pos_quality_empty=1
        ),
        Record(
            group='Все', region_name='Земля/Россия/Москва',
            total_count=4, verified_count=2,
            to_close=1, no_permalink=1,
            ambiguous_permalinks=0, ambiguous_ft_ids=0,
            ambiguous_permalinks_ymapsdf=0, ambiguous_ft_ids_ymapsdf=0,
            dist_equal=1,
            dist_over_half_m=1, dist_over_5m=1, dist_over_10m=1,
            dist_over_20m=1, dist_over_50m=1, dist_over_100m=1,
            dist_over_500m=1,
            pos_quality_user=0, pos_quality_precise=2, pos_quality_empty=2
        ),
        Record(
            group='Все', region_name='Земля/Россия/Нижний Новгород',
            total_count=2, verified_count=2,
            to_close=0, no_permalink=0,
            ambiguous_permalinks=1, ambiguous_ft_ids=2,
            ambiguous_permalinks_ymapsdf=1, ambiguous_ft_ids_ymapsdf=2,
            dist_equal=1,
            dist_over_half_m=1, dist_over_5m=1, dist_over_10m=1,
            dist_over_20m=1, dist_over_50m=1, dist_over_100m=0,
            dist_over_500m=0,
            pos_quality_user=2, pos_quality_precise=0, pos_quality_empty=0
        ),
        Record(
            group='Все', region_name='Земля/Россия',
            total_count=6, verified_count=4,
            to_close=1, no_permalink=1,
            ambiguous_permalinks=1, ambiguous_ft_ids=3,
            ambiguous_permalinks_ymapsdf=1, ambiguous_ft_ids_ymapsdf=3,
            dist_equal=2,
            dist_over_half_m=2, dist_over_5m=2, dist_over_10m=2,
            dist_over_20m=2, dist_over_50m=2, dist_over_100m=1,
            dist_over_500m=1,
            pos_quality_user=2, pos_quality_precise=2, pos_quality_empty=2
        ),
        Record(
            group='Все', region_name='Земля',
            total_count=6, verified_count=4,
            to_close=1, no_permalink=1,
            ambiguous_permalinks=1, ambiguous_ft_ids=3,
            ambiguous_permalinks_ymapsdf=1, ambiguous_ft_ids_ymapsdf=3,
            dist_equal=2,
            dist_over_half_m=2, dist_over_5m=2, dist_over_10m=2,
            dist_over_20m=2, dist_over_50m=2, dist_over_100m=1,
            dist_over_500m=1,
            pos_quality_user=2, pos_quality_precise=2, pos_quality_empty=2
        ),
    ])


def test_calculate_dist_data():
    result = nile_ut.yt_run(
        poi_stat.calculate_dist_data,
        raw_data=nile_ut.Table([
            Record(
                ft_id=1, ft_type_id=1401, permalink_id='permalink_id_1',
                geom_nk=common.POINT_NN_1, geom_altay=common.POINT_NN_1,
                dist=0.0, region_id=common.REGION_ID_NN),
            Record(
                ft_id=2, ft_type_id=1402, permalink_id='permalink_id_2',
                geom_nk=common.POINT_NN_1, geom_altay=common.POINT_NN_2,
                dist=common.DISTANCE_NN, region_id=common.REGION_ID_NN),
            Record(
                ft_id=3, ft_type_id=1403, permalink_id='permalink_id_3',
                geom_nk=common.POINT_MSK_1, geom_altay=common.POINT_MSK_1,
                dist=0.0, region_id=common.REGION_ID_MSK_1),
            Record(
                ft_id=4, ft_type_id=1404, permalink_id='permalink_id_4',
                geom_nk=common.POINT_MSK_1, geom_altay=None,
                dist=None, region_id=common.REGION_ID_MSK_2)
        ]),
        major_regions=nile_ut.Table(common.MAJOR_REGIONS),
        group_name='Все'
    )

    assert sorted(result) == sorted([
        Record(
            ft_id=2, permalink_id='permalink_id_2', dist=common.DISTANCE_NN,
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_2, lat_altay=common.LAT_NN_2,
            group='Все', region_name='Земля'),
        Record(
            ft_id=2, permalink_id='permalink_id_2', dist=common.DISTANCE_NN,
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_2, lat_altay=common.LAT_NN_2,
            group='Все', region_name='Земля/Россия'),
        Record(
            ft_id=2, permalink_id='permalink_id_2', dist=common.DISTANCE_NN,
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_2, lat_altay=common.LAT_NN_2,
            group='Все', region_name='Земля/Россия/Нижний Новгород'),
    ])


def test_calculate_close_data():
    result = nile_ut.yt_run(
        poi_stat.calculate_close_data,
        raw_data=nile_ut.Table([
            Record(
                ft_id=1, ft_type_id=1401, permalink_id='permalink_id_1',
                geom_nk=common.POINT_NN_1, geom_altay=common.POINT_NN_1,
                is_closed=True, region_id=common.REGION_ID_NN),
            Record(
                ft_id=2, ft_type_id=1402, permalink_id='permalink_id_2',
                geom_nk=common.POINT_NN_2, geom_altay=common.POINT_NN_2,
                region_id=common.REGION_ID_NN),
            Record(
                ft_id=3, ft_type_id=1403,
                region_id=common.REGION_ID_NN),
        ]),
        major_regions=nile_ut.Table(common.MAJOR_REGIONS),
        group_name='Все'
    )

    assert sorted(result) == sorted([
        Record(
            ft_id=1, permalink_id='permalink_id_1',
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_1, lat_altay=common.LAT_NN_1,
            group='Все', region_name='Земля'),
        Record(
            ft_id=1, permalink_id='permalink_id_1',
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_1, lat_altay=common.LAT_NN_1,
            group='Все', region_name='Земля/Россия'),
        Record(
            ft_id=1, permalink_id='permalink_id_1',
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_1, lat_altay=common.LAT_NN_1,
            group='Все', region_name='Земля/Россия/Нижний Новгород'),
    ])


def test_calculate_no_permalink_data():
    result = nile_ut.yt_run(
        poi_stat.calculate_no_permalink_data,
        raw_data=nile_ut.Table([
            Record(
                ft_id=1, ft_type_id=1401, permalink_id='permalink_id_1',
                geom_nk=common.POINT_NN_1, geom_altay=common.POINT_NN_1,
                region_id=common.REGION_ID_NN),
            Record(
                ft_id=2, ft_type_id=1402,
                geom_nk=common.POINT_NN_1,
                region_id=common.REGION_ID_NN),
            Record(
                ft_id=3, ft_type_id=1403, permalink_id='permalink_id_3',
                geom_nk=common.POINT_MSK_1, geom_altay=common.POINT_MSK_1,
                region_id=common.REGION_ID_MSK_1),
            Record(
                ft_id=4, ft_type_id=1404,
                geom_nk=common.POINT_MSK_1,
                region_id=common.REGION_ID_MSK_1),
        ]),
        major_regions=nile_ut.Table(common.MAJOR_REGIONS),
        group_name='Все'
    )

    assert sorted(result) == sorted([
        Record(ft_id=2, lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1, group='Все', region_name='Земля'),
        Record(ft_id=2, lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1, group='Все', region_name='Земля/Россия'),
        Record(ft_id=2, lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1, group='Все', region_name='Земля/Россия/Нижний Новгород'),
        Record(ft_id=4, lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1, group='Все', region_name='Земля'),
        Record(ft_id=4, lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1, group='Все', region_name='Земля/Россия'),
        Record(ft_id=4, lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1, group='Все', region_name='Земля/Россия/Москва'),
        Record(ft_id=4, lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1, group='Все', region_name='Земля/Россия/Москва/Мещанский район'),
    ])


def test_calculate_ambiguous_data():
    result = nile_ut.yt_run(
        poi_stat.calculate_ambiguous_data,
        raw_data=nile_ut.Table([
            Record(
                ft_id=11, ft_type_id=1401, permalink_id='permalink_id_1',
                geom_nk=common.POINT_NN_1, geom_altay=common.POINT_NN_1,
                region_id=common.REGION_ID_NN),
            Record(
                ft_id=12, ft_type_id=1401, permalink_id='permalink_id_1',
                geom_nk=common.POINT_NN_1, geom_altay=common.POINT_NN_1,
                region_id=common.REGION_ID_NN),
            Record(
                ft_id=13, ft_type_id=1401, permalink_id='permalink_id_1',
                geom_nk=common.POINT_NN_1, geom_altay=common.POINT_NN_1,
                region_id=common.REGION_ID_NN),
            Record(
                ft_id=21, ft_type_id=1401, permalink_id='permalink_id_2',
                geom_nk=common.POINT_NN_1, geom_altay=common.POINT_NN_1,
                region_id=common.REGION_ID_NN),
            Record(
                ft_id=31, ft_type_id=1401, permalink_id='permalink_id_3',
                geom_nk=common.POINT_MSK_1, geom_altay=common.POINT_MSK_1,
                region_id=common.REGION_ID_MSK_1),
            Record(
                ft_id=32, ft_type_id=1401, permalink_id='permalink_id_3',
                geom_nk=common.POINT_MSK_1, geom_altay=common.POINT_MSK_1,
                region_id=common.REGION_ID_MSK_1),
            Record(
                ft_id=14, ft_type_id=1401, permalink_id='permalink_id_1',
                geom_nk=common.POINT_MSK_1, geom_altay=common.POINT_MSK_1,
                region_id=common.REGION_ID_MSK_1),
            Record(
                ft_id=41, ft_type_id=1401, permalink_id='permalink_id_4',
                geom_nk=common.POINT_MSK_1, geom_altay=common.POINT_MSK_1,
                region_id=common.REGION_ID_MSK_1),
            Record(
                ft_id=51, ft_type_id=1401, permalink_id='permalink_id_5',
                geom_nk=common.POINT_MSK_2, geom_altay=common.POINT_MSK_2,
                region_id=common.REGION_ID_MSK_2),
            Record(
                ft_id=61, ft_type_id=1401, permalink_id='permalink_id_6',
                geom_nk=common.POINT_MSK_2, geom_altay=common.POINT_MSK_2,
                region_id=common.REGION_ID_MSK_2)
        ]),
        major_regions=nile_ut.Table(common.MAJOR_REGIONS),
        permalink_field_name='permalink_id',
        group_name='Все'
    )

    assert sorted(result) == sorted([
        Record(
            ft_id=11, permalink_id='permalink_id_1',
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_1, lat_altay=common.LAT_NN_1,
            group='Все', region_name='Земля'),
        Record(
            ft_id=11, permalink_id='permalink_id_1',
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_1, lat_altay=common.LAT_NN_1,
            group='Все', region_name='Земля/Россия'),
        Record(
            ft_id=11, permalink_id='permalink_id_1',
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_1, lat_altay=common.LAT_NN_1,
            group='Все', region_name='Земля/Россия/Нижний Новгород'),
        Record(
            ft_id=12, permalink_id='permalink_id_1',
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_1, lat_altay=common.LAT_NN_1,
            group='Все', region_name='Земля'),
        Record(
            ft_id=12, permalink_id='permalink_id_1',
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_1, lat_altay=common.LAT_NN_1,
            group='Все', region_name='Земля/Россия'),
        Record(
            ft_id=12, permalink_id='permalink_id_1',
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_1, lat_altay=common.LAT_NN_1,
            group='Все', region_name='Земля/Россия/Нижний Новгород'),
        Record(
            ft_id=13, permalink_id='permalink_id_1',
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_1, lat_altay=common.LAT_NN_1,
            group='Все', region_name='Земля'),
        Record(
            ft_id=13, permalink_id='permalink_id_1',
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_1, lat_altay=common.LAT_NN_1,
            group='Все', region_name='Земля/Россия'),
        Record(
            ft_id=13, permalink_id='permalink_id_1',
            lon_nk=common.LON_NN_1, lat_nk=common.LAT_NN_1,
            lon_altay=common.LON_NN_1, lat_altay=common.LAT_NN_1,
            group='Все', region_name='Земля/Россия/Нижний Новгород'),
        Record(
            ft_id=14, permalink_id='permalink_id_1',
            lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1,
            lon_altay=common.LON_MSK_1, lat_altay=common.LAT_MSK_1,
            group='Все', region_name='Земля'),
        Record(
            ft_id=14, permalink_id='permalink_id_1',
            lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1,
            lon_altay=common.LON_MSK_1, lat_altay=common.LAT_MSK_1,
            group='Все', region_name='Земля/Россия'),
        Record(
            ft_id=14, permalink_id='permalink_id_1',
            lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1,
            lon_altay=common.LON_MSK_1, lat_altay=common.LAT_MSK_1,
            group='Все', region_name='Земля/Россия/Москва'),
        Record(
            ft_id=14, permalink_id='permalink_id_1',
            lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1,
            lon_altay=common.LON_MSK_1, lat_altay=common.LAT_MSK_1,
            group='Все', region_name='Земля/Россия/Москва/Мещанский район'),
        Record(
            ft_id=31, permalink_id='permalink_id_3',
            lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1,
            lon_altay=common.LON_MSK_1, lat_altay=common.LAT_MSK_1,
            group='Все', region_name='Земля'),
        Record(
            ft_id=31, permalink_id='permalink_id_3',
            lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1,
            lon_altay=common.LON_MSK_1, lat_altay=common.LAT_MSK_1,
            group='Все', region_name='Земля/Россия'),
        Record(
            ft_id=31, permalink_id='permalink_id_3',
            lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1,
            lon_altay=common.LON_MSK_1, lat_altay=common.LAT_MSK_1,
            group='Все', region_name='Земля/Россия/Москва'),
        Record(
            ft_id=31, permalink_id='permalink_id_3',
            lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1,
            lon_altay=common.LON_MSK_1, lat_altay=common.LAT_MSK_1,
            group='Все', region_name='Земля/Россия/Москва/Мещанский район'),
        Record(
            ft_id=32, permalink_id='permalink_id_3',
            lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1,
            lon_altay=common.LON_MSK_1, lat_altay=common.LAT_MSK_1,
            group='Все', region_name='Земля'),
        Record(
            ft_id=32, permalink_id='permalink_id_3',
            lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1,
            lon_altay=common.LON_MSK_1, lat_altay=common.LAT_MSK_1,
            group='Все', region_name='Земля/Россия'),
        Record(
            ft_id=32, permalink_id='permalink_id_3',
            lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1,
            lon_altay=common.LON_MSK_1, lat_altay=common.LAT_MSK_1,
            group='Все', region_name='Земля/Россия/Москва'),
        Record(
            ft_id=32, permalink_id='permalink_id_3',
            lon_nk=common.LON_MSK_1, lat_nk=common.LAT_MSK_1,
            lon_altay=common.LON_MSK_1, lat_altay=common.LAT_MSK_1,
            group='Все', region_name='Земля/Россия/Москва/Мещанский район'),
    ])
