import common
import maps.wikimap.stat.kpi.poi_stat.lib.processors as pr

from maps.wikimap.stat.libs import nile_ut
from nile.api.v1 import Record


def test_add_point_geom():
    result = nile_ut.yt_run(
        pr.add_point_geom,
        stream=nile_ut.Table([
            Record(ft_id=1, ft_type_id=1401),
            Record(ft_id=2, ft_type_id=1402),
            Record(ft_id=3, ft_type_id=1403),
            Record(ft_id=4, ft_type_id=1404),
            Record(ft_id=5, ft_type_id=1405),
        ]),
        ft_center=nile_ut.Table([
            Record(ft_id=1, node_id=1),
            Record(ft_id=2, node_id=1),
            Record(ft_id=3, node_id=2),
            Record(ft_id=4, node_id=4),
        ]),
        node=nile_ut.Table([
            Record(node_id=1, shape='000001'),
            Record(node_id=2, shape='000002'),
            Record(node_id=3, shape='000003'),
            Record(node_id=5, shape='000005'),
        ]),
        geom_field_name='geom'
    )

    assert sorted(result) == sorted([
        Record(ft_id=1, ft_type_id=1401, node_id=1, shape='000001', geom='000001'),
        Record(ft_id=2, ft_type_id=1402, node_id=1, shape='000001', geom='000001'),
        Record(ft_id=3, ft_type_id=1403, node_id=2, shape='000002', geom='000002'),
    ])


def test_add_region_id():
    result = nile_ut.yt_run(
        pr.add_region_id,
        stream=nile_ut.Table([
            Record(ft_id=1, geom=common.POINT_NN_1),
            Record(ft_id=2, geom=common.POINT_MSK_1),
            Record(ft_id=3),
        ]),
        geom_field_name='geom'
    )

    assert sorted(result) == sorted([
        Record(ft_id=1, geom=common.POINT_NN_1, region_id=common.REGION_ID_NN),
        Record(ft_id=2, geom=common.POINT_MSK_1, region_id=common.REGION_ID_MSK_1),
        Record(ft_id=3, region_id=None),
    ])


def test_add_region_name():
    result = nile_ut.yt_run(
        pr.add_region_name,
        stream=nile_ut.Table([
            Record(ft_id=1, region_id=common.REGION_ID_NN),
            Record(ft_id=2, region_id=common.REGION_ID_MSK_2),
            Record(ft_id=3, region_id=0),
            Record(ft_id=4, region_id=None),
            Record(ft_id=5),
        ]),
        major_regions=nile_ut.Table(common.MAJOR_REGIONS)
    )

    assert sorted(result) == sorted([
        Record(ft_id=1, region_id=common.REGION_ID_NN, region_name='Земля'),
        Record(ft_id=1, region_id=common.REGION_ID_NN, region_name='Земля/Россия'),
        Record(ft_id=1, region_id=common.REGION_ID_NN, region_name='Земля/Россия/Нижний Новгород'),
        Record(ft_id=2, region_id=common.REGION_ID_MSK_2, region_name='Земля'),
        Record(ft_id=2, region_id=common.REGION_ID_MSK_2, region_name='Земля/Россия'),
        Record(ft_id=2, region_id=common.REGION_ID_MSK_2, region_name='Земля/Россия/Москва'),
        Record(ft_id=2, region_id=common.REGION_ID_MSK_2, region_name='Земля/Россия/Москва/Раменки'),
        Record(ft_id=3, region_id=0, region_name='Земля'),
        Record(ft_id=4, region_id=None, region_name='Земля'),
        Record(ft_id=5, region_name='Земля'),
    ])
