import maps.wikimap.stat.kpi.valuable_edits.moderated_edits.lib.moderated_edits as me
import maps.wikimap.stat.libs.common.lib.cli_options as cli_opts
from nile.api.v1 import cli
import os


EDITS_LOG_TABLES = 'logs/nmaps-edits-moderation-users-log/1d'


def eval_results_default(options):
    return os.path.join(options.analytics, EDITS_LOG_TABLES)


@cli.statinfra_job(options=[
    cli_opts.logs_option(),
    cli_opts.analytics_option(),
    cli_opts.results_option(eval_results_default, 'analytics'),
])
def make_job(job, options):
    results_path = cli_opts.get_results_path(options, eval_results_default)
    for date in options.dates:
        me.make_job(
            job,
            date=date,
            logs_path=options.logs,
            analytics_path=options.analytics,
            results_path=results_path,
        )
    return job


def main():
    cli.run()


if __name__ == "__main__":
    main()
