import maps.wikimap.stat.kpi.valuable_edits.report.lib.valuable_edits as ve
from maps.wikimap.stat.libs.common.lib import (
    dates as d,
    cli_options as cli_opts
)
from nile.api.v1 import cli


@cli.statinfra_job(options=[
    cli_opts.analytics_option(),
    cli_opts.agg_scale_option(),
    cli_opts.results_option()
])
def make_job(job, options, statface_client):
    results_path = cli_opts.get_results_path(options)
    for date in d.dates_to_update(options.dates):
        ve.make_report(
            job,
            statface_client,
            last_isodate=date,
            agg_scale=options.agg_scale,
            analytics_path=options.analytics,
            results_path=results_path
        )

    return job


def main():
    cli.run()


if __name__ == "__main__":
    main()
