import maps.wikimap.stat.libs.common.lib.cli_options as cli_opts
import maps.wikimap.stat.kpi.valuable_edits.report.lib.valuable_edits as ve

from nile.api.v1 import (
    local,
    clusters,
    statface,
    Record,
)


def test_local_example():
    edits_moderation_log = [

        #  Алжир moderation_resolved_resolution=None
        Record(
            action='object-created',
            branch_id='0',
            business_rubric_id='184107202',
            commit_id='5',
            ft_type_id='505',
            geom='[[5.66115031963,36.030390999],[5.7025217,36.069035518]]',
            iso_eventtime='2019-03-20 05:00:00',
            moderation_create_puid=None,
            moderation_create_source_uri=None,
            moderation_create_time=None,
            moderation_event_type=None,
            moderation_resolved_puid=None,
            moderation_resolved_resolution=None,
            moderation_resolved_source_uri='',
            moderation_resolved_time=None,
            moderation_status='moderator',
            moderation_task_id=None,
            object_category='urban_roadnet_areal',
            object_id='5',
            puid='5',
            region_id='20826',
            source_uri='prt://maps_um_back@um-back02h.maps.yandex.ru/var/lib/yandex/maps/wiki/stat/edits-log.tskv',
        ),

        #  Польша not_valuable, free, urban_roadnet_group, moderation_resolved_resolution=accept
        Record(
            action='object-modified',
            branch_id='0',
            business_rubric_id='184107202',
            commit_id='4',
            ft_type_id='242',
            geom='[[22.0768083493,51.4314719304],[22.0769752561,51.4319092246]]',
            iso_eventtime='2019-03-20 04:00:00',
            moderation_create_puid='104',
            moderation_create_source_uri='',
            moderation_create_time=None,
            moderation_event_type='',
            moderation_resolved_puid='103',
            moderation_resolved_resolution='accept',
            moderation_resolved_source_uri='',
            moderation_resolved_time=None,
            moderation_status='common',
            moderation_task_id='4',
            object_category='hydro_ln_el',
            object_id='4',
            puid='4',
            region_id='104114',
            source_uri='prt://maps_um_back@y3ubmyeq7wco5yl6.sas.yp-c.yandex.net/var/lib/yandex/maps/wiki/stat/edits-log.tskv'
        ),

        #  Кострома, local от города, paid, poi_group
        Record(
            action='object-modified',
            branch_id='0',
            business_rubric_id='184107202',
            commit_id='3',
            ft_type_id='165',
            geom='[[40.9039767299,57.7339356755],[40.9039767479,57.7339356851]]',
            iso_eventtime='2019-03-20 03:00:00',
            moderation_create_puid='103',
            moderation_create_source_uri='',
            moderation_create_time=None,
            moderation_event_type='',
            moderation_resolved_puid='103',
            moderation_resolved_resolution='accept',
            moderation_resolved_source_uri='',
            moderation_resolved_time=None,
            moderation_status='yandex_moderator',
            moderation_task_id='3',
            object_category='poi_edu',
            object_id='3',
            puid='3',
            region_id='7',
            source_uri='prt://maps_um_back@um-back01h.maps.yandex.ru/var/lib/yandex/maps/wiki/stat/edits-log.tskv'
        ),

        #  Кострома, local от России 225, free, poi_group
        Record(
            action='object-modified',
            branch_id='0',
            business_rubric_id='184107202',
            commit_id='3',
            ft_type_id='165',
            geom='[[40.9039767299,57.7339356824],[40.9039767479,57.7339356629]]',
            iso_eventtime='2019-03-20 05:00:00',
            moderation_create_puid='103',
            moderation_create_source_uri='',
            moderation_create_time=None,
            moderation_event_type='',
            moderation_resolved_puid='103',
            moderation_resolved_resolution='accept',
            moderation_resolved_source_uri='',
            moderation_resolved_time=None,
            moderation_status='moderator',
            moderation_task_id='5',
            object_category='poi_edu',
            object_id='5',
            puid='5',
            region_id='7',
            source_uri='prt://maps_um_back@um-back01h.maps.yandex.ru/var/lib/yandex/maps/wiki/stat/edits-log.tskv'
        ),

        #  Карелия, local от России 225, free, bld_group
        Record(
            action='object-created',
            branch_id='0',
            business_rubric_id='',
            commit_id='2',
            ft_type_id='',
            geom='[[30.66,61.68],[30.67,61.69]]',
            iso_eventtime='2019-03-20 02:00:00',
            moderation_create_puid='102',
            moderation_create_source_uri='',
            moderation_create_time=None,
            moderation_event_type='',
            moderation_resolved_puid='102',
            moderation_resolved_resolution='edit',
            moderation_resolved_source_uri='',
            moderation_resolved_time=None,
            moderation_status='expert',
            moderation_task_id='2',
            object_category='bld',
            object_id='2',
            puid='2',
            region_id='10937',
            source_uri='prt://maps_um_back@um-back01h.maps.yandex.ru/var/lib/yandex/maps/wiki/stat/edits-log.tskv'
        ),
    ]

    users_regions_data = [
        Record(
            puid='2',
            major_ids=['225', '7']
        ),
        Record(
            puid='3',
            major_ids=['10699', '7']
        ),
        Record(
            puid='4',
            major_ids=['7']
        ),
        Record(
            puid='5',
            major_ids=['3', '10937']
        ),
    ]

    valuable_categories = [
        Record(object_category='bld', category_group='bld_group'),
        Record(object_category='bld', category_group='all_valuable'),
        Record(object_category='rd_el', category_group='rd_group'),
        Record(object_category='rd_el', category_group='all_valuable'),
        Record(object_category='poi_edu', category_group='poi_group'),
        Record(object_category='poi_edu', category_group='all_valuable'),
        Record(object_category='urban_roadnet_areal', category_group='urban_roadnet_group'),
        Record(object_category='urban_roadnet_areal', category_group='all_valuable'),
        Record(object_category='hydro_ln_el', category_group='not_valuable'),

    ]

    major_regions = [
        Record(region_id='20826', major_id='10000', region_name='Земля', region_tree='\t10000\t', population=None, least_major=False),
        Record(region_id='20826', major_id='20826', region_name='Земля/Алжир', region_tree='\t10000\t20826\t', population='40400000', least_major=True),

        Record(region_id='104114', major_id='10000', region_name='Земля', region_tree='\t10000\t', population=None, least_major=False),
        Record(region_id='104114', major_id='120', region_name='Земля/Польша', region_tree='\t10000\t120\t', population='38483957', least_major=True),

        Record(region_id='225', major_id='10000', region_name='Земля', region_tree='\t10000\t', population=None, least_major=False),
        Record(region_id='225', major_id='225', region_name='Земля/Россия', region_tree='\t10000\t225\t', population='146880432', least_major=True),

        Record(region_id='3', major_id='10000', region_name='Земля', region_tree='\t10000\t', population=None, least_major=False),
        Record(region_id='3', major_id='225', region_name='Земля/Россия', region_tree='\t10000\t225\t', population='146880432', least_major=False),
        Record(region_id='3', major_id='3', region_name='Земля/Россия/Центральный федеральный округ', region_tree='\t10000\t225\t3\t', population='39311413', least_major=True),

        Record(region_id='10699', major_id='10000', region_name='Земля', region_tree='\t10000\t', population=None, least_major=False),
        Record(region_id='10699', major_id='225', region_name='Земля/Россия', region_tree='\t10000\t225\t', population='146880432', least_major=False),
        Record(region_id='10699', major_id='3', region_name='Земля/Россия/Центральный федеральный округ', region_tree='\t10000\t225\t3\t', population='39311413', least_major=False),
        Record(region_id='10699', major_id='10699', region_name='Земля/Россия/Центральный федеральный округ/Костромская область', region_tree='\t10000\t225\t3\t10699\t', population='643324',
                least_major=True),

        Record(region_id='7', major_id='10000', region_name='Земля', region_tree='\t10000\t', population=None, least_major=False),
        Record(region_id='7', major_id='225', region_name='Земля/Россия', region_tree='\t10000\t225\t', population='146880432', least_major=False),
        Record(region_id='7', major_id='3', region_name='Земля/Россия/Центральный федеральный округ', region_tree='\t10000\t225\t3\t', population='39311413', least_major=False),
        Record(region_id='7', major_id='10699', region_name='Земля/Россия/Центральный федеральный округ/Костромская область', region_tree='\t10000\t225\t3\t10699\t', population='643324',
                least_major=False),
        Record(region_id='7', major_id='7', region_name='Земля/Россия/Центральный федеральный округ/Костромская область/Кострома', region_tree='\t10000\t225\t3\t10699\t7\t', population='277280',
                least_major=True),
        Record(region_id='7', major_id='999999003', region_name='Земля/Россия/100K+', region_tree='\t10000\t225\t999999003\t', population=None, least_major=None),
        Record(region_id='7', major_id='7', region_name='Земля/Россия/100K+/Кострома', region_tree='\t10000\t225\t999999003\t7\t', population='277280', least_major=None),

        Record(region_id='17', major_id='10000', region_name='Земля', region_tree='\t10000\t', population=None, least_major=False),
        Record(region_id='17', major_id='225', region_name='Земля/Россия', region_tree='\t10000\t225\t', population='146880432', least_major=False),
        Record(region_id='17', major_id='17', region_name='Земля/Россия/Северо-Западный федеральный округ', region_tree='\t10000\t225\t17\t', population='13952003', least_major=True),

        Record(region_id='10937', major_id='10000', region_name='Земля', region_tree='\t10000\t', population=None, least_major=False),
        Record(region_id='10937', major_id='225', region_name='Земля/Россия', region_tree='\t10000\t225\t', population='146880432', least_major=False),
        Record(region_id='10937', major_id='17', region_name='Земля/Россия/Северо-Западный федеральный округ', region_tree='\t10000\t225\t17\t', population='13952003', least_major=False),
        Record(region_id='10937', major_id='10933', region_name='Земля/Россия/Северо-Западный федеральный округ/Республика Карелия', region_tree='\t10000\t225\t17\t10933\t', population='31039',
                least_major=True),
        Record(region_id='10937', major_id='999999002', region_name='Земля/Россия/10K+', region_tree='\t10000\t225\t999999002\t', population=None, least_major=None),
    ]

    result = []

    cluster = clusters.MockCluster()
    job = cluster.job()

    statface_client = statface.client.MockStatfaceClient()

    ve.make_report(
        job=job,
        statface_client=statface_client,
        last_isodate='2019-03-20',
        agg_scale='d',
        analytics_path=cli_opts.ANALYTICS_DEFAULT,
        results_path=None,
    )

    job.local_run(
        sources={
            "edits_moderation_log": local.StreamSource(edits_moderation_log),
            "users_regions_data": local.StreamSource(users_regions_data),
            "valuable_categories": local.StreamSource(valuable_categories),
            "major_regions": local.StreamSource(major_regions),
        },
        sinks={
            "intermediate_result": local.ListSink(result),
        }
    )

    assert sorted(result) == [
        Record(category_group='all_valuable', edits=1, locality='\tall\t', population=None, region_tree='\t10000\t225\t999999002\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\t', population='13952003', region_tree='\t10000\t225\t17\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\t', population='31039', region_tree='\t10000\t225\t17\t10933\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\t', population=None, region_tree='\t10000\t225\t999999002\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\t', population=None, region_tree='\t10000\t225\t999999003\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\t', population='13952003', region_tree='\t10000\t225\t17\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\t', population='277280', region_tree='\t10000\t225\t3\t10699\t7\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\t', population='277280', region_tree='\t10000\t225\t999999003\t7\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\t', population='31039', region_tree='\t10000\t225\t17\t10933\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\t', population='39311413', region_tree='\t10000\t225\t3\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\t', population='643324', region_tree='\t10000\t225\t3\t10699\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\talien\t', population=None, region_tree='\t10000\t225\t999999002\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\talien\t', population=None, region_tree='\t10000\t225\t999999003\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\talien\t', population='13952003', region_tree='\t10000\t225\t17\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\talien\t', population='277280', region_tree='\t10000\t225\t3\t10699\t7\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\talien\t', population='277280', region_tree='\t10000\t225\t999999003\t7\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\talien\t', population='31039', region_tree='\t10000\t225\t17\t10933\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\talien\t', population='643324', region_tree='\t10000\t225\t3\t10699\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tfree\tlocal\t', population='39311413', region_tree='\t10000\t225\t3\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tpaid\t', population=None, region_tree='\t10000\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tpaid\t', population=None, region_tree='\t10000\t225\t999999003\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tpaid\t', population='146880432', region_tree='\t10000\t225\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tpaid\t', population='277280', region_tree='\t10000\t225\t3\t10699\t7\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tpaid\t', population='277280', region_tree='\t10000\t225\t999999003\t7\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tpaid\t', population='39311413', region_tree='\t10000\t225\t3\t', users=1),
        Record(category_group='all_valuable', edits=1, locality='\tall\tpaid\t', population='643324', region_tree='\t10000\t225\t3\t10699\t', users=1),
        Record(category_group='all_valuable', edits=2, locality='\tall\t', population=None, region_tree='\t10000\t225\t999999003\t', users=2),
        Record(category_group='all_valuable', edits=2, locality='\tall\t', population='277280', region_tree='\t10000\t225\t3\t10699\t7\t', users=2),
        Record(category_group='all_valuable', edits=2, locality='\tall\t', population='277280', region_tree='\t10000\t225\t999999003\t7\t', users=2),
        Record(category_group='all_valuable', edits=2, locality='\tall\t', population='39311413', region_tree='\t10000\t225\t3\t', users=2),
        Record(category_group='all_valuable', edits=2, locality='\tall\t', population='643324', region_tree='\t10000\t225\t3\t10699\t', users=2),
        Record(category_group='all_valuable', edits=2, locality='\tall\tfree\t', population=None, region_tree='\t10000\t', users=2),
        Record(category_group='all_valuable', edits=2, locality='\tall\tfree\t', population='146880432', region_tree='\t10000\t225\t', users=2),
        Record(category_group='all_valuable', edits=2, locality='\tall\tfree\tlocal\t', population=None, region_tree='\t10000\t', users=2),
        Record(category_group='all_valuable', edits=2, locality='\tall\tfree\tlocal\t', population='146880432', region_tree='\t10000\t225\t', users=2),
        Record(category_group='all_valuable', edits=3, locality='\tall\t', population=None, region_tree='\t10000\t', users=3),
        Record(category_group='all_valuable', edits=3, locality='\tall\t', population='146880432', region_tree='\t10000\t225\t', users=3),

        Record(category_group='bld_group', edits=1, locality='\tall\t', population=None, region_tree='\t10000\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\t', population=None, region_tree='\t10000\t225\t999999002\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\t', population='13952003', region_tree='\t10000\t225\t17\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\t', population='146880432', region_tree='\t10000\t225\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\t', population='31039', region_tree='\t10000\t225\t17\t10933\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\tfree\t', population=None, region_tree='\t10000\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\tfree\t', population=None, region_tree='\t10000\t225\t999999002\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\tfree\t', population='13952003', region_tree='\t10000\t225\t17\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\tfree\t', population='146880432', region_tree='\t10000\t225\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\tfree\t', population='31039', region_tree='\t10000\t225\t17\t10933\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\tfree\talien\t', population=None, region_tree='\t10000\t225\t999999002\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\tfree\talien\t', population='13952003', region_tree='\t10000\t225\t17\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\tfree\talien\t', population='31039', region_tree='\t10000\t225\t17\t10933\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\tfree\tlocal\t', population=None, region_tree='\t10000\t', users=1),
        Record(category_group='bld_group', edits=1, locality='\tall\tfree\tlocal\t', population='146880432', region_tree='\t10000\t225\t', users=1),

        Record(category_group='not_valuable', edits=1, locality='\tall\t', population=None, region_tree='\t10000\t', users=1),
        Record(category_group='not_valuable', edits=1, locality='\tall\t', population='38483957', region_tree='\t10000\t120\t', users=1),
        Record(category_group='not_valuable', edits=1, locality='\tall\tfree\t', population=None, region_tree='\t10000\t', users=1),
        Record(category_group='not_valuable', edits=1, locality='\tall\tfree\t', population='38483957', region_tree='\t10000\t120\t', users=1),
        Record(category_group='not_valuable', edits=1, locality='\tall\tfree\talien\t', population='38483957', region_tree='\t10000\t120\t', users=1),
        Record(category_group='not_valuable', edits=1, locality='\tall\tfree\tlocal\t', population=None, region_tree='\t10000\t', users=1),

        Record(category_group='poi_group', edits=1, locality='\tall\tfree\t', population=None, region_tree='\t10000\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tfree\t', population=None, region_tree='\t10000\t225\t999999003\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tfree\t', population='146880432', region_tree='\t10000\t225\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tfree\t', population='277280', region_tree='\t10000\t225\t3\t10699\t7\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tfree\t', population='277280', region_tree='\t10000\t225\t999999003\t7\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tfree\t', population='39311413', region_tree='\t10000\t225\t3\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tfree\t', population='643324', region_tree='\t10000\t225\t3\t10699\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tfree\talien\t', population=None, region_tree='\t10000\t225\t999999003\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tfree\talien\t', population='277280', region_tree='\t10000\t225\t3\t10699\t7\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tfree\talien\t', population='277280', region_tree='\t10000\t225\t999999003\t7\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tfree\talien\t', population='643324', region_tree='\t10000\t225\t3\t10699\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tfree\tlocal\t', population=None, region_tree='\t10000\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tfree\tlocal\t', population='146880432', region_tree='\t10000\t225\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tfree\tlocal\t', population='39311413', region_tree='\t10000\t225\t3\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tpaid\t', population=None, region_tree='\t10000\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tpaid\t', population=None, region_tree='\t10000\t225\t999999003\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tpaid\t', population='146880432', region_tree='\t10000\t225\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tpaid\t', population='277280', region_tree='\t10000\t225\t3\t10699\t7\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tpaid\t', population='277280', region_tree='\t10000\t225\t999999003\t7\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tpaid\t', population='39311413', region_tree='\t10000\t225\t3\t', users=1),
        Record(category_group='poi_group', edits=1, locality='\tall\tpaid\t', population='643324', region_tree='\t10000\t225\t3\t10699\t', users=1),
        Record(category_group='poi_group', edits=2, locality='\tall\t', population=None, region_tree='\t10000\t', users=2),
        Record(category_group='poi_group', edits=2, locality='\tall\t', population=None, region_tree='\t10000\t225\t999999003\t', users=2),
        Record(category_group='poi_group', edits=2, locality='\tall\t', population='146880432', region_tree='\t10000\t225\t', users=2),
        Record(category_group='poi_group', edits=2, locality='\tall\t', population='277280', region_tree='\t10000\t225\t3\t10699\t7\t', users=2),
        Record(category_group='poi_group', edits=2, locality='\tall\t', population='277280', region_tree='\t10000\t225\t999999003\t7\t', users=2),
        Record(category_group='poi_group', edits=2, locality='\tall\t', population='39311413', region_tree='\t10000\t225\t3\t', users=2),
        Record(category_group='poi_group', edits=2, locality='\tall\t', population='643324', region_tree='\t10000\t225\t3\t10699\t', users=2),
    ]
