from lxml import etree
import yt.wrapper as yt
from maps.wikimap.stat.kpi.valuable_edits.valuable_categories.lib import (
    cli,
    valuable_categories as vc
)


def main():
    parser = cli.make_parser()
    args = parser.parse_args()

    category_groups_xml = etree.parse(args.category_groups)
    vc_rows = vc.extract(category_groups_xml)

    if args.command == 'upload':
        client = yt.YtClient(proxy=args.proxy, token=args.token)
        results_path = cli.eval_results_path(args)
        vc.upload(vc_rows, client, results_path)
    elif args.command == 'print':
        vc.print_json(vc_rows)
    else:
        raise ValueError('unexpected command: {}'.format(args.command))


if __name__ == '__main__':
    main()
